(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    423392,       7586]
NotebookOptionsPosition[    422124,       7547]
NotebookOutlinePosition[    422717,       7568]
CellTagsIndexPosition[    422674,       7565]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["", "Text",
 CellChangeTimes->{{3.8505675482933645`*^9, 3.8505675511099663`*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.8505674817413397`*^9, 3.850567491054656*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"N0", "=", 
   RowBox[{"10", "^", "3"}]}], ";", 
  RowBox[{"EV", "=", "0"}], ";", 
  RowBox[{"kT", "=", "0.026"}], ";", 
  RowBox[{"L", "=", 
   RowBox[{"10", "^", 
    RowBox[{"-", "5"}]}]}], ";", 
  RowBox[{"f", "=", "0.5"}], ";", 
  RowBox[{"\[Theta]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
  RowBox[{"\[Tau]d", "=", "0.1"}], ";", " ", 
  RowBox[{"uv0", "=", 
   RowBox[{"-", "1"}]}], ";", 
  RowBox[{"uv1", "=", "0"}], ";", 
  RowBox[{"uvH", "=", 
   RowBox[{"-", "0.8"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Aeq", "[", "u_", "]"}], ":=", 
   RowBox[{
    RowBox[{"2", "/", "3"}], "N0", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
     RowBox[{"3", "/", "2"}]]}]}], "  "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cmu", "[", "u_", "]"}], ":=", 
  RowBox[{
   RowBox[{"N0", " ", "/", "kT"}], " ", 
   RowBox[{"Abs", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
     RowBox[{"1", "/", "2"}]], "  ", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Idc", "[", "u_", "]"}], ":=", 
    RowBox[{
     RowBox[{"-", "\[Theta]"}], " ", 
     RowBox[{"L", "/", "\[Tau]e"}], " ", 
     RowBox[{"Aeq", "[", "u", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Iu", " ", "curve"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io1", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A00", "=", 
   RowBox[{"Aeq", "[", "uvH", "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960532270595*^9}, {3.9069608107416534`*^9, 
   3.906960894501176*^9}, 3.906976975428384*^9, 3.9069784461360517`*^9, {
   3.9069784939955707`*^9, 3.906978495519633*^9}, {3.906979520056976*^9, 
   3.906979527909192*^9}, {3.9070299969708767`*^9, 3.9070299973647575`*^9}, 
   3.9070302622793455`*^9, {3.907031054878291*^9, 3.907031101672268*^9}, {
   3.907031132657627*^9, 3.907031137965227*^9}, {3.907031258015709*^9, 
   3.907031258244317*^9}, 3.907060462885079*^9, {3.9070616210919228`*^9, 
   3.9070617379829817`*^9}, {3.9070618359373693`*^9, 
   3.9070618491419787`*^9}, {3.9072168098312087`*^9, 
   3.9072168879034996`*^9}, {3.9072169598535347`*^9, 
   3.9072169971857233`*^9}, {3.9072170607219973`*^9, 3.907217066892645*^9}, {
   3.9076577595519457`*^9, 3.9076578173877373`*^9}, {3.9076578614233837`*^9, 
   3.907657894347175*^9}, {3.9076579602806206`*^9, 3.9076579846181087`*^9}, {
   3.9076596607447786`*^9, 3.9076596756372747`*^9}, {3.912649758684204*^9, 
   3.912649760833685*^9}, {3.912649837259575*^9, 3.912649848570344*^9}, {
   3.9126499517854204`*^9, 3.912649970892383*^9}, 3.912650059947663*^9, {
   3.9126500901878223`*^9, 3.912650090409895*^9}, 3.9126501210930157`*^9, {
   3.912650161299636*^9, 3.912650195770377*^9}, {3.9126502444052167`*^9, 
   3.912650249087671*^9}, {3.9126503503333225`*^9, 3.9126504621854153`*^9}, 
   3.9126506010978127`*^9, 3.912650669840725*^9, {3.912768414775481*^9, 
   3.912768499461568*^9}, {3.912768532787694*^9, 3.9127685546208143`*^9}, {
   3.912769054075884*^9, 3.912769202942466*^9}, {3.91276928130552*^9, 
   3.9127693421278896`*^9}, {3.9127693895200415`*^9, 3.91276939347456*^9}, {
   3.912769449251079*^9, 3.9127695130058765`*^9}, {3.9127695460304613`*^9, 
   3.912769637406728*^9}, {3.912769672995297*^9, 3.912769683695554*^9}, {
   3.9127699655129433`*^9, 3.9127702032882056`*^9}, {3.912770296658707*^9, 
   3.9127703175743523`*^9}, {3.912770427094532*^9, 3.91277044594245*^9}, 
   3.9127705303609056`*^9, {3.912770571895234*^9, 3.9127706020178995`*^9}, {
   3.9127706486135855`*^9, 3.9127706716451917`*^9}, {3.912770711413762*^9, 
   3.912770754484521*^9}, {3.9127708044063478`*^9, 3.9127708106291575`*^9}, {
   3.9127708503988996`*^9, 3.912770864756321*^9}, {3.9127709027091455`*^9, 
   3.912770959220462*^9}, {3.9127709899464912`*^9, 3.9127710660360575`*^9}, {
   3.9128198078072987`*^9, 3.912820031509515*^9}, {3.91282006827859*^9, 
   3.9128201061755395`*^9}, {3.9128201414506645`*^9, 
   3.9128202576441517`*^9}, {3.912820301485941*^9, 3.912820302036003*^9}, {
   3.91282118902829*^9, 3.912821200535576*^9}, {3.9128212987625976`*^9, 
   3.9128212997021604`*^9}, {3.9128213384189405`*^9, 3.912821339532572*^9}, {
   3.91380808097643*^9, 3.9138080914374475`*^9}, {3.913808133264759*^9, 
   3.9138081867755365`*^9}, {3.9138082503482437`*^9, 
   3.9138082841458397`*^9}, {3.9138085090926466`*^9, 3.913808519144635*^9}, {
   3.913944174749754*^9, 3.9139442412817116`*^9}, {3.9139443551487813`*^9, 
   3.913944355512908*^9}, {3.9139446795397243`*^9, 3.9139447171058693`*^9}, {
   3.913944750208041*^9, 3.9139447589918194`*^9}, {3.913944789150079*^9, 
   3.9139448749836483`*^9}, {3.9139449239924626`*^9, 
   3.9139449441650796`*^9}, {3.9139587224296885`*^9, 
   3.9139587446201954`*^9}, {3.9139588142087173`*^9, 3.913958817747795*^9}, {
   3.91395894456537*^9, 3.9139589457330937`*^9}, {3.9139590071767883`*^9, 
   3.9139590074760413`*^9}, 3.9139751840757055`*^9, {3.9139805254478717`*^9, 
   3.913980527285986*^9}, {3.914061651207717*^9, 3.9140616728059535`*^9}, {
   3.9143019528100643`*^9, 3.914302017740336*^9}, {3.914636108138605*^9, 
   3.914636116823386*^9}, {3.919138938697628*^9, 3.919139014338743*^9}, {
   3.919139150904415*^9, 3.9191391637002487`*^9}, {3.9191392332801642`*^9, 
   3.919139255454362*^9}, {3.9191392924448996`*^9, 3.919139349802597*^9}, {
   3.919139486406455*^9, 3.9191395156439233`*^9}, 3.9191397792319717`*^9, {
   3.9191398464250755`*^9, 3.919139879667204*^9}, 3.9191410988780746`*^9, {
   3.9191411766037207`*^9, 3.9191411772892494`*^9}, 3.9191412252244153`*^9, {
   3.9201792347943506`*^9, 3.9201792566416655`*^9}, {3.920179517706969*^9, 
   3.920179521348885*^9}, 3.920180117535499*^9, {3.920180492592327*^9, 
   3.9201805023656654`*^9}, 3.9202501912315874`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {GrayLevel[0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwlxQ04E3gAx3EmJkVvXrbUWUneKktJb0qOOy93ql11UtILilRemgoll4iU
FKtGCRm5XoRxwn5/bOuFTUwt3DlTRKR0nXdzd899n+fzfBfsP8bypaioqHj+
67//nybprH9P58QyyWO3hFXrxqkk64yR8PEvTLL/uu6RsGEqucfmVkjOMIlw
mXlL32cqmdYcckPjBJPEebGKmxVU8pu253jEQSbRKb97qKiGSqoEh8PZzkwy
L8ylwS+OSs4uXRWRrcUktn1XsyQ6VKIe6dbRbGRF1jOHo7ZO1SBd9nNdtugu
JUWMGm9zPXVyT5TOdVtlSXwzq7fVmkwhrSt14jUDzUnnqZQY44VqxKHemieL
NSVyZW1JvRWF9O/9yA6RmJDrra+Mrc1VSXfsbP3+MWNy1VmXt8dUhSQeahLa
2S8kypqg7YIjSlRtlpvnPGQQNs+rydJnHK+dNp8ZmfUNkSr0PDadHoW2Ws7d
c3RDcsvOVqM3Yxg/xnozdVxpZKrLhLkqdxD+ZtR9T3bpEY8Hl1ko+QqV1SnP
1lTOJo5Vws89+V/QLev8ul5zJuH9faAsL+8zWjRM8mTUaaRJ/Za20dWPcCnc
lqy8qUE4UeXXRNE96D9dGLjGkELm/xpkXFHSiZ9vqxwLCR5Hm82x2xe5ChSG
DoVY13yFvtrZ3zWMW1F1lWUUSu8DZaObYc+UVpz+vtih7EMvPobre9Z2tUBj
aIc/vaIXwi/35Un5LViQlTNq6t2LkI7mRpp1C3YsIS+ieB9QX7XiucWmZtid
6vU2XduDC2ff89295fD9MkspYndhbMI9iZMmg4VHfaSpgwLtMcdTP4XL8PKn
sS3zDRQQT+OmOXvKsGiLm5ltXzuu0DtzR2kySEyHdso57VhsE0H2cBphUTF9
N7f1T2wNzB1YnNyAmXHzuNud/oA7fzL3qHY9NO3bKE6sN6DXuBYz6qRwfK/v
Wqz+Bu9eppLGBCkuplRdO14mx6k+y+ZVmlIgfU18zwI57hp7aE1SJJipzCx5
OPgKo8kFgUnDL5A2jfZq6JEMuUf3LS94K0ZiATOh5JkUl987bSjliRF8UCGl
uksRttfCTeAvRmMhu2ZCJoEj6y+fuk8isEmSXauiDu025290jwkx22mWhK1e
C/pE3iRDtwaMOXdZqkeeQiXs0nQzeTVatHw/6kyI0d0fTLfiViNgRqlhwyUx
StrXrrBjVGOJm7TpxGMRWMI6v51LqrDupVlQkKoQegaKNON4AZa51dxbLiJ4
p5nPXz5DAMm5keeMfQSFoyH1G1Mr8aogy6p4DHBvm6K2O7MCwVnp5w+EChCb
YxaQUvYEy7Z18VzDyjG8Imi1+ocSrOccDEqQ8CE2WcOaE1SCm/3mHX4MPlIM
KIELBvmQN4R5GrCLsXzsWoYdhQ9PWnW55qIiBFSXaoTNLYKXoqlIdKMApZnK
e5LUh8jRefrWXpyLy3qiL0W8Byj7muqZ9pgHv/iL67il9zFu0JbhnJkDvWCa
xK85H/viIj68vZSNUHvrz5PzclH57k53+voMuBYPr+5ayoNgsL379e5bWGiG
6LoNOWhUexQ1My4NDTN+mHNzbzYsrjwc8Rm9jj2C2kAf5wzcMBqP5B9IhjbP
Q8kMuIV8a9q7EX4SKi51Jk1cTMMAu3gxrTIRc70mCzn111GhcO7cS4vDc8dE
xwMDqeC4ZNucOBqDk0vor63mpMA2YXOMsj0ar8esR57tuAJ2m//hc5vCofU0
Ss9yIBEn/SO1QjvYOMS5uVq4Mh5rLwS8Ofk8GGLfol1eJ89jKD1YbcPQYRjb
SM4MlkfDv0N06IjSB5Sp0m+NJiOQtNLPdjLYC5W5qglbY48juU43KC+ChYHE
gDtUwwAMOH+X6QUHvEzJ3vmGtQPyUZNGy6FFyAtvjew9po/Qhfp3ljFEgn8A
NloOAw==
     "]]}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1, 0}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.9069604407168236`*^9, 3.9069605332272882`*^9}, {
   3.906960873128422*^9, 3.906960895531418*^9}, 3.906976395013073*^9, 
   3.9069768261688895`*^9, 3.9069768566022353`*^9, 3.906976976761789*^9, 
   3.9069783364612823`*^9, 3.906978446755515*^9, 3.9069784966360397`*^9, 
   3.906979529032095*^9, 3.907029772655319*^9, 3.9070299989453187`*^9, 
   3.907030263361041*^9, {3.90703105661911*^9, 3.9070311034146614`*^9}, 
   3.907031139329981*^9, 3.9070312609672413`*^9, 3.9070604634211054`*^9, {
   3.907061676379919*^9, 3.9070617074839373`*^9}, 3.907061739927741*^9, 
   3.907061850623412*^9, 3.9071484107390194`*^9, 3.907149316528576*^9, {
   3.907216830020722*^9, 3.9072168690736713`*^9}, {3.907216986441079*^9, 
   3.9072169979590325`*^9}, {3.907217061489775*^9, 3.9072170675900564`*^9}, 
   3.9072195872223215`*^9, 3.9076389821284227`*^9, {3.907657849989588*^9, 
   3.9076578954976673`*^9}, {3.907657963814293*^9, 3.907657985463826*^9}, {
   3.907659663191266*^9, 3.907659676333522*^9}, 3.9076602819193583`*^9, 
   3.9077769656344566`*^9, 3.9126498516824837`*^9, 3.9126499726689463`*^9, 
   3.9126500609405794`*^9, 3.9126500919897842`*^9, 3.912650122172583*^9, {
   3.9126501902975006`*^9, 3.9126501965834703`*^9}, {3.9126503540020475`*^9, 
   3.912650388036002*^9}, {3.9126504474372797`*^9, 3.912650463692734*^9}, 
   3.912650602273307*^9, 3.912650672142622*^9, 3.9127691708103347`*^9, 
   3.912769204339058*^9, 3.912769344056361*^9, 3.9127693944939623`*^9, {
   3.91276950752767*^9, 3.9127695135006533`*^9}, 3.9127695472789445`*^9, {
   3.91276958070685*^9, 3.912769640773776*^9}, {3.9127696770277123`*^9, 
   3.9127696844337893`*^9}, {3.912769976179847*^9, 3.9127700622893705`*^9}, {
   3.9127701128059435`*^9, 3.912770159854647*^9}, 3.912770194401973*^9, 
   3.912770234418211*^9, {3.9127703033567085`*^9, 3.912770318728407*^9}, {
   3.9127704302576885`*^9, 3.9127704577555428`*^9}, 3.9127705033778143`*^9, {
   3.912770580166715*^9, 3.912770602674535*^9}, {3.912770649978569*^9, 
   3.9127706722518063`*^9}, {3.912770729731973*^9, 3.9127707549712605`*^9}, 
   3.912770817300192*^9, 3.9127708658522806`*^9, {3.912770907497669*^9, 
   3.912770961000368*^9}, {3.9127710118261724`*^9, 3.912771068816465*^9}, 
   3.9128197772924275`*^9, {3.912819822025155*^9, 3.912820012098296*^9}, {
   3.9128200425073357`*^9, 3.91282010670754*^9}, {3.912820156700299*^9, 
   3.912820258617489*^9}, 3.9128203044680405`*^9, {3.9128211932404394`*^9, 
   3.912821201719369*^9}, 3.9128213005959864`*^9, 3.912821344803238*^9, 
   3.9129203082809577`*^9, 3.912924814040944*^9, 3.9138081041432886`*^9, {
   3.913808137783062*^9, 3.9138081574861727`*^9}, 3.9138081880263014`*^9, 
   3.9138082852494926`*^9, {3.9138085109219937`*^9, 3.9138085203919535`*^9}, 
   3.913944247246892*^9, 3.9139443563966236`*^9, {3.9139447224751434`*^9, 
   3.913944760020854*^9}, {3.913944796798437*^9, 3.9139448759662085`*^9}, {
   3.9139449265588183`*^9, 3.9139449451606817`*^9}, 3.913958749387721*^9, 
   3.9139588188150773`*^9, {3.913958986942833*^9, 3.9139590084836893`*^9}, 
   3.913975019460681*^9, 3.913975186405835*^9, 3.91398052988524*^9, 
   3.9140616734485283`*^9, {3.9143019652329783`*^9, 3.914302018403781*^9}, 
   3.9143750128265266`*^9, 3.9146361196135254`*^9, {3.9191389810400543`*^9, 
   3.919139014959218*^9}, 3.9191391656081343`*^9, 3.9191392615687814`*^9, 
   3.9191393105174246`*^9, 3.919139352629927*^9, {3.9191395059087553`*^9, 
   3.919139516237733*^9}, 3.9191397801678686`*^9, {3.919139861618489*^9, 
   3.919139880656597*^9}, 3.9191407916257615`*^9, 3.9191411783632746`*^9, 
   3.919141226128358*^9, 3.9191689199872236`*^9, 3.9201181122849836`*^9, 
   3.920179258168473*^9, 3.9201795229670663`*^9, 3.9201801179222603`*^9, {
   3.9201804938071117`*^9, 3.920180503365594*^9}, 3.920186101548499*^9, 
   3.920198849339812*^9, 3.9202501394731417`*^9}],

Cell[BoxData["113784.65563594442`"], "Output",
 CellChangeTimes->{{3.9069604407168236`*^9, 3.9069605332272882`*^9}, {
   3.906960873128422*^9, 3.906960895531418*^9}, 3.906976395013073*^9, 
   3.9069768261688895`*^9, 3.9069768566022353`*^9, 3.906976976761789*^9, 
   3.9069783364612823`*^9, 3.906978446755515*^9, 3.9069784966360397`*^9, 
   3.906979529032095*^9, 3.907029772655319*^9, 3.9070299989453187`*^9, 
   3.907030263361041*^9, {3.90703105661911*^9, 3.9070311034146614`*^9}, 
   3.907031139329981*^9, 3.9070312609672413`*^9, 3.9070604634211054`*^9, {
   3.907061676379919*^9, 3.9070617074839373`*^9}, 3.907061739927741*^9, 
   3.907061850623412*^9, 3.9071484107390194`*^9, 3.907149316528576*^9, {
   3.907216830020722*^9, 3.9072168690736713`*^9}, {3.907216986441079*^9, 
   3.9072169979590325`*^9}, {3.907217061489775*^9, 3.9072170675900564`*^9}, 
   3.9072195872223215`*^9, 3.9076389821284227`*^9, {3.907657849989588*^9, 
   3.9076578954976673`*^9}, {3.907657963814293*^9, 3.907657985463826*^9}, {
   3.907659663191266*^9, 3.907659676333522*^9}, 3.9076602819193583`*^9, 
   3.9077769656344566`*^9, 3.9126498516824837`*^9, 3.9126499726689463`*^9, 
   3.9126500609405794`*^9, 3.9126500919897842`*^9, 3.912650122172583*^9, {
   3.9126501902975006`*^9, 3.9126501965834703`*^9}, {3.9126503540020475`*^9, 
   3.912650388036002*^9}, {3.9126504474372797`*^9, 3.912650463692734*^9}, 
   3.912650602273307*^9, 3.912650672142622*^9, 3.9127691708103347`*^9, 
   3.912769204339058*^9, 3.912769344056361*^9, 3.9127693944939623`*^9, {
   3.91276950752767*^9, 3.9127695135006533`*^9}, 3.9127695472789445`*^9, {
   3.91276958070685*^9, 3.912769640773776*^9}, {3.9127696770277123`*^9, 
   3.9127696844337893`*^9}, {3.912769976179847*^9, 3.9127700622893705`*^9}, {
   3.9127701128059435`*^9, 3.912770159854647*^9}, 3.912770194401973*^9, 
   3.912770234418211*^9, {3.9127703033567085`*^9, 3.912770318728407*^9}, {
   3.9127704302576885`*^9, 3.9127704577555428`*^9}, 3.9127705033778143`*^9, {
   3.912770580166715*^9, 3.912770602674535*^9}, {3.912770649978569*^9, 
   3.9127706722518063`*^9}, {3.912770729731973*^9, 3.9127707549712605`*^9}, 
   3.912770817300192*^9, 3.9127708658522806`*^9, {3.912770907497669*^9, 
   3.912770961000368*^9}, {3.9127710118261724`*^9, 3.912771068816465*^9}, 
   3.9128197772924275`*^9, {3.912819822025155*^9, 3.912820012098296*^9}, {
   3.9128200425073357`*^9, 3.91282010670754*^9}, {3.912820156700299*^9, 
   3.912820258617489*^9}, 3.9128203044680405`*^9, {3.9128211932404394`*^9, 
   3.912821201719369*^9}, 3.9128213005959864`*^9, 3.912821344803238*^9, 
   3.9129203082809577`*^9, 3.912924814040944*^9, 3.9138081041432886`*^9, {
   3.913808137783062*^9, 3.9138081574861727`*^9}, 3.9138081880263014`*^9, 
   3.9138082852494926`*^9, {3.9138085109219937`*^9, 3.9138085203919535`*^9}, 
   3.913944247246892*^9, 3.9139443563966236`*^9, {3.9139447224751434`*^9, 
   3.913944760020854*^9}, {3.913944796798437*^9, 3.9139448759662085`*^9}, {
   3.9139449265588183`*^9, 3.9139449451606817`*^9}, 3.913958749387721*^9, 
   3.9139588188150773`*^9, {3.913958986942833*^9, 3.9139590084836893`*^9}, 
   3.913975019460681*^9, 3.913975186405835*^9, 3.91398052988524*^9, 
   3.9140616734485283`*^9, {3.9143019652329783`*^9, 3.914302018403781*^9}, 
   3.9143750128265266`*^9, 3.9146361196135254`*^9, {3.9191389810400543`*^9, 
   3.919139014959218*^9}, 3.9191391656081343`*^9, 3.9191392615687814`*^9, 
   3.9191393105174246`*^9, 3.919139352629927*^9, {3.9191395059087553`*^9, 
   3.919139516237733*^9}, 3.9191397801678686`*^9, {3.919139861618489*^9, 
   3.919139880656597*^9}, 3.9191407916257615`*^9, 3.9191411783632746`*^9, 
   3.919141226128358*^9, 3.9191689199872236`*^9, 3.9201181122849836`*^9, 
   3.920179258168473*^9, 3.9201795229670663`*^9, 3.9201801179222603`*^9, {
   3.9201804938071117`*^9, 3.920180503365594*^9}, 3.920186101548499*^9, 
   3.920198849339812*^9, 3.92025013947665*^9}]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.9139445815144615`*^9, 3.913944583470003*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Theta]", "=", 
   RowBox[{"-", "1"}]}], ";", " ", 
  RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
  RowBox[{"\[Tau]d", "=", "0.8"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.05"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
           RowBox[{"3", "/", "2"}]]}], "  ", "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Aeq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh1", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
           RowBox[{"3", "/", "2"}]]}], "  ", "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uv1", "]"}], "\[Equal]", "Av1"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gh2", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
            RowBox[{
             RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
           RowBox[{"L", " ", 
            RowBox[{"f", "/", "\[Tau]d"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Aeq", "[", "u", "]"}], "-", 
              RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", "sol"}],
         "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<u\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
         ",", "\"\<\>\""}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox[
             RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
           RowBox[{"3", "/", "2"}]]}], "  ", "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", "Av2"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh3", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Aeq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh4", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uv1", "]"}], "\[Equal]", "Av1"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh5", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", "Av2"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gh6", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
            RowBox[{
             RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
           RowBox[{"L", " ", 
            RowBox[{"f", "/", "\[Tau]d"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Aeq", "[", "u", "]"}], "-", 
              RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", "sol"}],
         "]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<u\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
         ",", "\"\<\>\""}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io1", ",", "gh2", ",", "gh3", ",", "gh5", ",", "gh6", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"io1", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"uv", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<V (V)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
          RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
        ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3"}], ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", 
          RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", ",",
           "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}],
         ",", "None", ",", "None"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Gray"}], "}"}], 
       "}"}]}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io1", ",", "gh5", ",", "gh6", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960421970504*^9}, 3.90696058512084*^9, {
   3.9069606314181366`*^9, 3.906960643357847*^9}, {3.9069606827315874`*^9, 
   3.9069606842067842`*^9}, {3.9069607800459027`*^9, 3.906960789339467*^9}, {
   3.906960946958927*^9, 3.906961015693834*^9}, {3.9069610665773287`*^9, 
   3.9069610942448244`*^9}, {3.906975980921613*^9, 3.906976089812361*^9}, {
   3.9069761287780294`*^9, 3.9069761444527407`*^9}, {3.9069761802392483`*^9, 
   3.9069764111837945`*^9}, {3.9069764723969927`*^9, 
   3.9069764965177555`*^9}, {3.9069765456510816`*^9, 3.906976559809983*^9}, {
   3.9069766596602173`*^9, 3.9069766598802757`*^9}, 3.9069767005917444`*^9, {
   3.906976778520788*^9, 3.906976842147175*^9}, {3.90697690958217*^9, 
   3.906976948797903*^9}, {3.906977008286579*^9, 3.9069770258571725`*^9}, {
   3.9069783088004336`*^9, 3.9069783295883393`*^9}, {3.9069784555681205`*^9, 
   3.9069784736312475`*^9}, {3.9069785149274707`*^9, 
   3.9069785203580103`*^9}, {3.9069785545147533`*^9, 
   3.9069786442875185`*^9}, {3.9069786792021737`*^9, 
   3.9069788093775425`*^9}, {3.906978853786457*^9, 3.906978872127804*^9}, {
   3.906978907937706*^9, 3.9069789439029903`*^9}, {3.906979021341509*^9, 
   3.9069791012891383`*^9}, {3.9069793249639287`*^9, 
   3.9069793698176155`*^9}, {3.9069794500914555`*^9, 
   3.9069794867247863`*^9}, {3.9069795534312057`*^9, 3.906979579384478*^9}, {
   3.9069796794955473`*^9, 3.906979691967578*^9}, {3.90697984152462*^9, 
   3.9069798495662622`*^9}, {3.9069798829331303`*^9, 3.906979892303535*^9}, {
   3.906979929815036*^9, 3.9069799897806015`*^9}, {3.907029838923909*^9, 
   3.9070298429045696`*^9}, 3.907029873049452*^9, {3.9070299082271347`*^9, 
   3.9070299615551324`*^9}, {3.9070300098261147`*^9, 3.907030048469262*^9}, {
   3.907030090835805*^9, 3.907030236396055*^9}, {3.9070302925336046`*^9, 
   3.907030304052057*^9}, {3.907030372815591*^9, 3.9070304865078115`*^9}, {
   3.907030557887286*^9, 3.9070305689133244`*^9}, {3.9070308911683903`*^9, 
   3.907030892187997*^9}, {3.9070604376835546`*^9, 3.907060445993576*^9}, {
   3.9070605369359646`*^9, 3.907060610391075*^9}, {3.9070607652596164`*^9, 
   3.907060779428796*^9}, {3.90706081432941*^9, 3.9070608151924467`*^9}, {
   3.9070608516888237`*^9, 3.907060854768076*^9}, {3.907060944967448*^9, 
   3.907060990845777*^9}, {3.907061076512681*^9, 3.9070611086597958`*^9}, {
   3.9070611484876804`*^9, 3.9070611988926153`*^9}, {3.9070612582075396`*^9, 
   3.907061352628416*^9}, {3.9070614831261873`*^9, 3.9070615845827394`*^9}, {
   3.907061784180231*^9, 3.9070618159858637`*^9}, {3.907061890477336*^9, 
   3.907061943454452*^9}, {3.9071484650166793`*^9, 3.90714866651295*^9}, {
   3.907148762155178*^9, 3.9071488404975348`*^9}, {3.9071488774252872`*^9, 
   3.9071489294181747`*^9}, {3.9071489765577335`*^9, 3.907148976814991*^9}, {
   3.9071491725272875`*^9, 3.907149241274995*^9}, 3.9071493285419173`*^9, {
   3.9071493746789184`*^9, 3.907149483905308*^9}, {3.9071495447705164`*^9, 
   3.907149550473424*^9}, {3.9071495819630795`*^9, 3.90714963340366*^9}, {
   3.9071497225947556`*^9, 3.9071497240775113`*^9}, {3.907149760297258*^9, 
   3.907149761731573*^9}, {3.9071498152856555`*^9, 3.907149875310998*^9}, 
   3.9071499205002947`*^9, {3.9071499577662582`*^9, 3.9071499702396035`*^9}, {
   3.9071500532046795`*^9, 3.9071500682462764`*^9}, {3.907218618548807*^9, 
   3.9072187011296597`*^9}, {3.9072195014873066`*^9, 
   3.9072195025316906`*^9}, {3.90721955313033*^9, 3.907219605997478*^9}, {
   3.9076388883376904`*^9, 3.907639028857774*^9}, {3.9076584642948866`*^9, 
   3.9076584677515554`*^9}, 3.9076585061822867`*^9, {3.9076585847633705`*^9, 
   3.9076586673533773`*^9}, {3.9076587071776705`*^9, 3.907658763185525*^9}, {
   3.907658814220379*^9, 3.9076588335250573`*^9}, {3.907658905205724*^9, 
   3.907658950762456*^9}, {3.907660119522422*^9, 3.9076601635769453`*^9}, 
   3.9126500418645983`*^9, {3.912650272877923*^9, 3.9126503212520823`*^9}, {
   3.912650484389138*^9, 3.912650572012165*^9}, {3.912650656766632*^9, 
   3.9126506581126027`*^9}, {3.9126507259529123`*^9, 3.912650777581822*^9}, 
   3.912651074711319*^9, {3.9126512031248045`*^9, 3.912651213319991*^9}, 
   3.912651703687234*^9, {3.912770083842639*^9, 3.9127701076862574`*^9}, {
   3.9128202786546226`*^9, 3.912820284120411*^9}, 3.9128203334420757`*^9, {
   3.9128203658705187`*^9, 3.91282056892971*^9}, {3.912820649630741*^9, 
   3.912820661602646*^9}, {3.9128206955003443`*^9, 3.912820724768431*^9}, 
   3.9128207658429365`*^9, {3.9128210569191675`*^9, 3.9128210648083296`*^9}, 
   3.9128210964617248`*^9, 3.9128211283606553`*^9, 3.9128212232449136`*^9, 
   3.912821276435539*^9, 3.9128214180597515`*^9, {3.912821544243472*^9, 
   3.9128215499947147`*^9}, {3.9128217996313906`*^9, 
   3.9128218286437273`*^9}, {3.912821877012741*^9, 3.912821923396287*^9}, {
   3.9128219675831423`*^9, 3.9128221124228954`*^9}, {3.912920245593502*^9, 
   3.912920245966591*^9}, {3.9139445874276905`*^9, 3.91394459507491*^9}, {
   3.9139450187138863`*^9, 3.9139450343858995`*^9}, {3.913945205447682*^9, 
   3.913945248472603*^9}, {3.913945412690005*^9, 3.9139455155179462`*^9}, {
   3.913958962378629*^9, 3.9139589785035114`*^9}, {3.9139590402712264`*^9, 
   3.9139590937141848`*^9}, 3.9139750141153145`*^9, {3.9139750744801207`*^9, 
   3.9139751224167085`*^9}, {3.9139752153934174`*^9, 3.91397523521216*^9}, {
   3.9139752681667395`*^9, 3.9139752765309496`*^9}, {3.9139754210256305`*^9, 
   3.91397543855688*^9}, {3.913975474761815*^9, 3.913975549799944*^9}, {
   3.9139756202766843`*^9, 3.913975621473342*^9}, {3.913976355232353*^9, 
   3.9139763564720173`*^9}, 3.913976468052901*^9, {3.913976504313478*^9, 
   3.9139766047022376`*^9}, {3.9139768730666857`*^9, 
   3.9139769991515765`*^9}, {3.9139805364785786`*^9, 
   3.9139805578142247`*^9}, {3.9143020649613595`*^9, 3.914302072021001*^9}, {
   3.914302194959444*^9, 3.914302202483561*^9}, {3.9191390449333115`*^9, 
   3.919139125489049*^9}, {3.9191391862084427`*^9, 3.919139212733096*^9}, {
   3.9191393296015463`*^9, 3.9191393355361643`*^9}, {3.919139393908128*^9, 
   3.9191394603885593`*^9}, 3.919139538292508*^9, {3.9191395898427453`*^9, 
   3.9191395945714526`*^9}, {3.9191397104148407`*^9, 3.9191397261812196`*^9}, 
   3.919139790543318*^9, 3.919139967192321*^9, {3.9191406455936623`*^9, 
   3.919140690845147*^9}, {3.9191407735213203`*^9, 3.9191407743776417`*^9}, {
   3.9191408181117997`*^9, 3.9191408270078845`*^9}, {3.9191408657281303`*^9, 
   3.919140902915256*^9}, {3.9191410060045266`*^9, 3.9191410203172483`*^9}, 
   3.919141070320388*^9, {3.919141163927287*^9, 3.9191411872159586`*^9}, {
   3.9191412577972193`*^9, 3.9191412976368313`*^9}, {3.9191688870873775`*^9, 
   3.919168933052214*^9}, {3.9201182584505105`*^9, 3.920118274636175*^9}, {
   3.9201183148461*^9, 3.920118343218148*^9}, {3.9201792697127*^9, 
   3.920179337060371*^9}, {3.920179374212452*^9, 3.920179400344658*^9}, {
   3.9201794569014792`*^9, 3.920179487538362*^9}, {3.92017952752343*^9, 
   3.920179632661135*^9}, {3.920179687305022*^9, 3.92017976326361*^9}, {
   3.9201798316074123`*^9, 3.9201798667633142`*^9}, {3.9201798998755927`*^9, 
   3.9201799158641057`*^9}, {3.920179953776236*^9, 3.9201799981623473`*^9}, {
   3.9201805316932325`*^9, 3.9201805494027853`*^9}, {3.9201860831182747`*^9, 
   3.9201861551547318`*^9}, 3.920186314100003*^9, 3.920186350665934*^9, {
   3.9201987605778465`*^9, 3.920198842313061*^9}, {3.9201988946130877`*^9, 
   3.9201989974218063`*^9}, {3.9201990338435297`*^9, 
   3.9201990430735903`*^9}, {3.920199690212242*^9, 3.9201996916760683`*^9}, {
   3.920200804471526*^9, 3.920200816376642*^9}, {3.920201028488816*^9, 
   3.920201053684864*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwlxQ040wkcwHEmJkUqL1vqLJK3ylLoTb9/HXde7lS7clLSC4ooL02FkktE
SopVo4SMXEkYJy+/P7b1wiamFu6cKSJSus67ubvnvs/zeb5LDx5n+VKUlJQ8
//Xf/0+d7Gl6T+fEMYnHrom2G6eoZPZZQ8HjX5jEwRs6QeFjVPI+m1slPssk
BKvM2wc/U8k5baE31U4yiXgvVmmbnEr+puk5FXmYSWhV3jtSUk8la2uORrCd
mMTicOdmv3gqeW6lbWSOBpOwG7yWLdaikqpRrt1thlbEJuZY9I7ZamQvsch5
u85KooRR722uq0reF2ZwXW0tCd+sup0NJrPIjrVaCeqB5kTP6dRYYyMVcmuT
NU8aZ0rIFA1lTVYUcmj/R3ao2IS40fHK2NpcmeyLW6A3NGlMXHPS4e0zVSKT
jrQK7AkjQlEfvKsmSIG122TmuYUMgs3zarX0mcLXjtvOjs//hpDIdT22nJlA
TZXce+fpBsRtezu1gcwx/DHOm6nlQiNmO0+bK3NH0N+MeuDJHl3C4+EVFpZ9
RaV1qc/WVy8gHGoFn/sLvmCftOfrJnVtgvf3oYr8/M/YrmaSL6XOIVpVb2sa
XvuIzsU7UxS31AhOdOV1YUw/Dp0pDlxvQCGW/BpsXFXWgz/fUToeGjIFnTbH
71ziyrE4bDTUuv4r6Kmc+13NuANrr7EMw+iDQAFXg/5ZHXjm+9KtFR8G4GOE
nmdDbzuqjbr706sGQPDlgSy5oB2XZudOmHoPQGh3WwvNuh3dV5AvonkfoKl2
zXOLLW1of3rA23RDP1w8957v5i1D3y/zFUJ2L0xOuyVz0qVo4dEUZbpVDl2x
J9I+RUjx5U+T25foy0E0h5vu5CnFZdtdzewGu+AqvSdvgiZFsenobhmnC5bb
RJL7OC1oUTV3L7fjT9gRmDe8PKUZteMXc3c5/gFu/Jm8Y5pNqE50UhxZb4Be
71LKaJSgw3s9l1LVN/DuZRrZkijBS6m1109UyOD0oGWbrboEMWN9Qv9SGdwz
9tCYoYhRW5FVVjjyCiZSigKTx15g+hzaq9FHUsg7dmB10VsRJhUxE8ueSeDK
e8fN5TwRhhyWS6huEgjfb+Fa4y/ClmJ2/bRUDA6sv3waPwmRTSbbd8gbocvm
ws2+SQEucJwvZqs2AH06f4ahU4+MhfdYykFPQSn88lwzWR22a/h+1JoWQd9Q
CN2KW4cB88oNmi+LoKxrwxp7Rh2ucJW0nnwsBJag0W/3ilrc+NIsOFhZALr6
8nTjhBpc5Vp/f7WQhHfqBfzV82pQfH78OeMACcUToU2QVo2virKtSicR3Dpn
qezNqsKQ7IwLh8JqIC7XLCC14gmu2tnLcwmvhLE1wetUP5ThJs7h4EQxH0Qm
61kLg8vw1pB5tx+DD6n6lMClI3yUNYd76rNLYfXk9Ux7Ch89aXWV6stKIKCu
XC18UQl6yVtLhDeLoDxLcV+cVoi5Wk/fEqI8uKIr/FLCe4gVX9M80x/zwC/h
0kZu+QOc0u/MdMrKBd0QmtivrQAPxEd+eHs5B8II688zi/Ow+t3dvoxNmeBS
OraudyUPa0a6+l7vvQ1GZhjTuDkXW1QeRWvHp0PzvB8W3tqfgxZXC8d9Jm7A
vpqGQB+nTLxpOBXFP5QCmjwPBTPgNhZY096N85Oh6nJP8vSldBxmly6nVSfB
Iq+ZYk7TDaySO/Xsp8XDc4ckh0PDachxzrE5eSwWTq2gv7ZamIp2idtiFV0x
8HrSevyZ+1Vkd/ofPb8lAjSeRutaDifhKf8ojbBuNhzh3FonWJuAGy4GvDn1
PAREviV7vE5dwNGMEJXNo0fB2EZ8dqQyBv27hUeCFD5AmS351nAmEpPX+tnN
hHhBdZ5y4o64E5jSqBOcH8mC4aSAu1SDABx2+i7LC7fCy9Sc3W9Y7iibMGmx
HF0G+REdUQPH9TDMSO/uKoZw8z/Z+OD0
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVk3k41AsXx1VCKWWpSFEqktsiUl3LGcsNJZVEiqgklS2iy00oWyj8ZsaW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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1Xk0Ft8fB/AZy5dUskRoIVosFVKi1Fw92ijZQoj0QyRbJVnKUiSSRBKy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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk4VesXB3ApRaOEKIRwUSRKcbEolQwViXKRJrpkqFDm6aIkoRIpUyky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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV13k4VVsUAHCzRhnKUyFz1FNRhMpOKGMhqSRUMj2SiqKumTIlkVKJJFGR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      "]]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1, 0}, {-0.5, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.92020105464921*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[1], LineBox[CompressedData["
1:eJwlxQ040wkcwHEmJkUqL1vqLJK3ylLoTb9/HXde7lS7clLSC4ooL02FkktE
SopVo4SMXEkYJy+/P7b1wiamFu6cKSJSus67ubvnvs/zeb5LDx5n+VKUlJQ8
//Xf/0+d7Gl6T+fEMYnHrom2G6eoZPZZQ8HjX5jEwRs6QeFjVPI+m1slPssk
BKvM2wc/U8k5baE31U4yiXgvVmmbnEr+puk5FXmYSWhV3jtSUk8la2uORrCd
mMTicOdmv3gqeW6lbWSOBpOwG7yWLdaikqpRrt1thlbEJuZY9I7ZamQvsch5
u85KooRR722uq0reF2ZwXW0tCd+sup0NJrPIjrVaCeqB5kTP6dRYYyMVcmuT
NU8aZ0rIFA1lTVYUcmj/R3ao2IS40fHK2NpcmeyLW6A3NGlMXHPS4e0zVSKT
jrQK7AkjQlEfvKsmSIG122TmuYUMgs3zarX0mcLXjtvOjs//hpDIdT22nJlA
TZXce+fpBsRtezu1gcwx/DHOm6nlQiNmO0+bK3NH0N+MeuDJHl3C4+EVFpZ9
RaV1qc/WVy8gHGoFn/sLvmCftOfrJnVtgvf3oYr8/M/YrmaSL6XOIVpVb2sa
XvuIzsU7UxS31AhOdOV1YUw/Dp0pDlxvQCGW/BpsXFXWgz/fUToeGjIFnTbH
71ziyrE4bDTUuv4r6Kmc+13NuANrr7EMw+iDQAFXg/5ZHXjm+9KtFR8G4GOE
nmdDbzuqjbr706sGQPDlgSy5oB2XZudOmHoPQGh3WwvNuh3dV5AvonkfoKl2
zXOLLW1of3rA23RDP1w8957v5i1D3y/zFUJ2L0xOuyVz0qVo4dEUZbpVDl2x
J9I+RUjx5U+T25foy0E0h5vu5CnFZdtdzewGu+AqvSdvgiZFsenobhmnC5bb
RJL7OC1oUTV3L7fjT9gRmDe8PKUZteMXc3c5/gFu/Jm8Y5pNqE50UhxZb4Be
71LKaJSgw3s9l1LVN/DuZRrZkijBS6m1109UyOD0oGWbrboEMWN9Qv9SGdwz
9tCYoYhRW5FVVjjyCiZSigKTx15g+hzaq9FHUsg7dmB10VsRJhUxE8ueSeDK
e8fN5TwRhhyWS6huEgjfb+Fa4y/ClmJ2/bRUDA6sv3waPwmRTSbbd8gbocvm
ws2+SQEucJwvZqs2AH06f4ahU4+MhfdYykFPQSn88lwzWR22a/h+1JoWQd9Q
CN2KW4cB88oNmi+LoKxrwxp7Rh2ucJW0nnwsBJag0W/3ilrc+NIsOFhZALr6
8nTjhBpc5Vp/f7WQhHfqBfzV82pQfH78OeMACcUToU2QVo2virKtSicR3Dpn
qezNqsKQ7IwLh8JqIC7XLCC14gmu2tnLcwmvhLE1wetUP5ThJs7h4EQxH0Qm
61kLg8vw1pB5tx+DD6n6lMClI3yUNYd76rNLYfXk9Ux7Ch89aXWV6stKIKCu
XC18UQl6yVtLhDeLoDxLcV+cVoi5Wk/fEqI8uKIr/FLCe4gVX9M80x/zwC/h
0kZu+QOc0u/MdMrKBd0QmtivrQAPxEd+eHs5B8II688zi/Ow+t3dvoxNmeBS
OraudyUPa0a6+l7vvQ1GZhjTuDkXW1QeRWvHp0PzvB8W3tqfgxZXC8d9Jm7A
vpqGQB+nTLxpOBXFP5QCmjwPBTPgNhZY096N85Oh6nJP8vSldBxmly6nVSfB
Iq+ZYk7TDaySO/Xsp8XDc4ckh0PDachxzrE5eSwWTq2gv7ZamIp2idtiFV0x
8HrSevyZ+1Vkd/ofPb8lAjSeRutaDifhKf8ojbBuNhzh3FonWJuAGy4GvDn1
PAREviV7vE5dwNGMEJXNo0fB2EZ8dqQyBv27hUeCFD5AmS351nAmEpPX+tnN
hHhBdZ5y4o64E5jSqBOcH8mC4aSAu1SDABx2+i7LC7fCy9Sc3W9Y7iibMGmx
HF0G+REdUQPH9TDMSO/uKoZw8z/Z+OD0
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk4VesXB3ApRaOEKIRwUSRKcbEolQwViXKRJrpkqFDm6aIkoRIpUyky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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV13k4VVsUAHCzRhnKUyFz1FNRhMpOKGMhqSRUMj2SiqKumTIlkVKJJFGR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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.243883219954649, 2.1145124716553303`}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.8",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.24964285714285706`, 1.725623582766442}, {Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"-", "1"}]}], {-0.19914399092970547`, 2.6003401360544216`}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.2",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.2799263038548754, 1.3418367346938802`}, {Left, Baseline},
      Alignment->{Left, Top}]}, {
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.42360342253013583`, 
       0.570690093363222}, {-0.6374705571342719, 1.1421480444274352`}}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.5052360755913606, 
       1.506064243023086}, {-0.2939331421682857, 0.9210596090532861}}]}}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-0.5, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920201069683298*^9, 3.9202010994026384`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0.5, 0], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwlxQ040wkcwHEmJkUqL1vqLJK3ylLoTb9/HXde7lS7clLSC4ooL02FkktE
SopVo4SMXEkYJy+/P7b1wiamFu6cKSJSus67ubvnvs/zeb5LDx5n+VKUlJQ8
//Xf/0+d7Gl6T+fEMYnHrom2G6eoZPZZQ8HjX5jEwRs6QeFjVPI+m1slPssk
BKvM2wc/U8k5baE31U4yiXgvVmmbnEr+puk5FXmYSWhV3jtSUk8la2uORrCd
mMTicOdmv3gqeW6lbWSOBpOwG7yWLdaikqpRrt1thlbEJuZY9I7ZamQvsch5
u85KooRR722uq0reF2ZwXW0tCd+sup0NJrPIjrVaCeqB5kTP6dRYYyMVcmuT
NU8aZ0rIFA1lTVYUcmj/R3ao2IS40fHK2NpcmeyLW6A3NGlMXHPS4e0zVSKT
jrQK7AkjQlEfvKsmSIG122TmuYUMgs3zarX0mcLXjtvOjs//hpDIdT22nJlA
TZXce+fpBsRtezu1gcwx/DHOm6nlQiNmO0+bK3NH0N+MeuDJHl3C4+EVFpZ9
RaV1qc/WVy8gHGoFn/sLvmCftOfrJnVtgvf3oYr8/M/YrmaSL6XOIVpVb2sa
XvuIzsU7UxS31AhOdOV1YUw/Dp0pDlxvQCGW/BpsXFXWgz/fUToeGjIFnTbH
71ziyrE4bDTUuv4r6Kmc+13NuANrr7EMw+iDQAFXg/5ZHXjm+9KtFR8G4GOE
nmdDbzuqjbr706sGQPDlgSy5oB2XZudOmHoPQGh3WwvNuh3dV5AvonkfoKl2
zXOLLW1of3rA23RDP1w8957v5i1D3y/zFUJ2L0xOuyVz0qVo4dEUZbpVDl2x
J9I+RUjx5U+T25foy0E0h5vu5CnFZdtdzewGu+AqvSdvgiZFsenobhmnC5bb
RJL7OC1oUTV3L7fjT9gRmDe8PKUZteMXc3c5/gFu/Jm8Y5pNqE50UhxZb4Be
71LKaJSgw3s9l1LVN/DuZRrZkijBS6m1109UyOD0oGWbrboEMWN9Qv9SGdwz
9tCYoYhRW5FVVjjyCiZSigKTx15g+hzaq9FHUsg7dmB10VsRJhUxE8ueSeDK
e8fN5TwRhhyWS6huEgjfb+Fa4y/ClmJ2/bRUDA6sv3waPwmRTSbbd8gbocvm
ws2+SQEucJwvZqs2AH06f4ahU4+MhfdYykFPQSn88lwzWR22a/h+1JoWQd9Q
CN2KW4cB88oNmi+LoKxrwxp7Rh2ucJW0nnwsBJag0W/3ilrc+NIsOFhZALr6
8nTjhBpc5Vp/f7WQhHfqBfzV82pQfH78OeMACcUToU2QVo2virKtSicR3Dpn
qezNqsKQ7IwLh8JqIC7XLCC14gmu2tnLcwmvhLE1wetUP5ThJs7h4EQxH0Qm
61kLg8vw1pB5tx+DD6n6lMClI3yUNYd76rNLYfXk9Ux7Ch89aXWV6stKIKCu
XC18UQl6yVtLhDeLoDxLcV+cVoi5Wk/fEqI8uKIr/FLCe4gVX9M80x/zwC/h
0kZu+QOc0u/MdMrKBd0QmtivrQAPxEd+eHs5B8II688zi/Ow+t3dvoxNmeBS
OraudyUPa0a6+l7vvQ1GZhjTuDkXW1QeRWvHp0PzvB8W3tqfgxZXC8d9Jm7A
vpqGQB+nTLxpOBXFP5QCmjwPBTPgNhZY096N85Oh6nJP8vSldBxmly6nVSfB
Iq+ZYk7TDaySO/Xsp8XDc4ckh0PDachxzrE5eSwWTq2gv7ZamIp2idtiFV0x
8HrSevyZ+1Vkd/ofPb8lAjSeRutaDifhKf8ojbBuNhzh3FonWJuAGy4GvDn1
PAREviV7vE5dwNGMEJXNo0fB2EZ8dqQyBv27hUeCFD5AmS351nAmEpPX+tnN
hHhBdZ5y4o64E5jSqBOcH8mC4aSAu1SDABx2+i7LC7fCy9Sc3W9Y7iibMGmx
HF0G+REdUQPH9TDMSO/uKoZw8z/Z+OD0
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVk3k41AsXx1VCKWWpSFEqktsiUl3LGcsNJZVEiqgklS2iy00oWyj8ZsaW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      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1Xk0Ft8fB/AZy5dUskRoIVosFVKi1Fw92ijZQoj0QyRbJVnKUiSSRBKy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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk4VesXB3ApRaOEKIRwUSRKcbEolQwViXKRJrpkqFDm6aIkoRIpUyky
REnmxT6jYzriHEqGzCRJosTpt39/7efzPPt5n7X3+13rfeXOelpd4Ofj41u7
hI/v/8++V5z4lJQxXF/ZsfYwbQ7mk4yWPngwhhNSAr25dXMgGlDgc+/+GGqU
5Q6urJkDk/2RdncSxtDktEt8U+kcFLXtUoi8OYYBrM2uJ3LmIGzm7lsvvzHs
KH2i4nlrDuS1rXoOnRpD39wl31mWc3C+vHnbrMQYSr49EqTQOws3K5dRQ2+P
orjKgHfA2A+4Onz678OrRrFE8/sO+oofsHHbaGr6rRGkBr9W4VOfAXu3gl9b
l4ygo+ELb9qB7+Dc/kB7OGQYHw9fHunxmob1OujF/T6E2yYfiP0b9w183m64
Z+06hIOChmpBJVOQ5ng7SXh8EG1/3JMK+PAVLi4xTpp3HMQh6fV+dlqTMNe4
xUe+ewCvJWZ3zRdNgOErZf1OhwF8eqbuZYjBZ1C968Ff1daPTTazTqtKx+D9
o/fPuq36UWWa+WKp5SioZIWZqDE+oR7/PjjYOQyadTZtKw0+oXVA2eymy0PA
J2Spr1TTh/cOaZ78sW0QPM1vPPXU6kPVx+ecT3D74dDles6Xc72YN871Vsj6
BN8MF+xPmvWgV+uU3C6nPlhrfLO0Z083lnVrb3I40wOlyU7Nfdofcfup4CzD
fR8hY7C4z0C2C5+55/gkr/sAouEWxRJSH3BHVuvfVZs7Yd5qv/Va6fcoF1ht
5GHKha2bX387LdiJJ3Mifzl5tANnl7uF2vIOLPodWbSl+R3UH8h8YjPJQXuv
4M/lqq2gEbOjMbWrHY8v657qdGoBeVnB1/ZdbWgqt9n9n+5GsCmwu+dHe4cL
hKfvflcWiMbOaYkQrfj38lKGlDMTHC6igGRNK5YLnqqudmTCM+Poji0VrRil
HjNw1pYJexbFA9RetSJ10IFabsIEOw9twiSrFfWidD+nbGNCxjGfYyHhrXgx
Tf1fhWkGbBf7fmliXyuqSjH/OIczwDhtMptOYePizfXH61/SwfVsxogvstF6
xyB9OocO8UpWKn9VsvGtmK6jXBYdugrf5Ee/YuN2PuXft+/R4QoGvjbJZGOQ
i6hgth8dMvpW1rGC2agYZ27QYEyHRfm/PjbrsDEx8+NDXg8N5Ec6pUN2s3H2
3F2z5k4amOTFnN6xk40TmwP0n7yjwT2tyf47ymwUUY4ftafTYLvxm7FjG9m4
zrDYZ10hDUpYUZPZYy1Yf2K/3pVgGrgfRYXC0y2oy/iktXsrDYxVxaKybFvw
PLPy8hoZGkgJuI0kHW3B4iWyDuMSNGisEH8RAi1ozs2BV2vJ9ZU8dlhuacHQ
hezD/vNUmFiQ0p3pacbpD0GyE++o4PrC/6iuYzMOXguztI+mwr5IdpG6TTOa
eGZSG8KpsMlJSWTrkWbMyPHlQTAVWGLv2lcZNOPL0oh6bR8qqISp2HVLN6M2
61ebwzkqjNp2ng/tbsJ3tuiVaEgFZwFtf7p9E+o10f1TeRT4+fJ05RrrJjwx
/LfVsXkKxNjdXLA2a0Lrj3pDK2cpUPjyY/CAThOGT/DvS/hCgdlTERF8G5vw
3PLQ7/0fKRBVyI7VbW1EGy8J6dQqCmTbuqUXHmhEH+GN4xdCKaDNf7/vh14j
3p+J1WkPpAAzv0ZOf1cjPnx+0tnEjwITS0SeNsg34ofLuvb7rlBgV35Zzuif
BhyPk+8IPE8BKt/yV/IVDcjasPXXalMKDOZmUJPUG9DV2NglU5IC/M+rBi4r
NaByu4j2ojgFZJ928lvINKCFHAscRSngkCZstHRtAy77emeFxjoKcBNDqz2/
sHB0eW2YiABZT4BTqUk+C6+dxPG2bwQMXw/kbH3KwrhGp/aIrwQs802e4aWy
8KD+yRU6Xwgw8mJrvrnFQtOT/eavRwmoOG/4Us6NhW9m4z1HegkosJDNmVdh
Yb9xwscjLQQ0muoxOHIs5CZeZBxvImD80MnhIkkWjo1/F3JsIEBpX7yCixAL
J8SrUsIZBGRo82W2jdZjs6vC4qpaAhK39KXkP6/Hr1CUKvuKgCKphbLo9Hq8
KK3sHlBEQLOkROfZB/Wo5pDztKuQgFWix8Qlo+vx2UG/w/l5BPwnWJsY6VyP
1lYO/8VlE+D7Lf2Wo2I9aizOx9k+JECj9sjNs9L1eEK+v2hdCllf3GKUs1g9
prVdXN/0gADH7f+EewjUY+rF1gTb+wQccBH3Cx5i4qPcqzl58QTwdtN8w7uZ
SJ+s7Lh9h4CyZd7eURwmLmikmvvEEbA9q9UzjsZEK9WUldaxBIh2xzqnZTNR
+c3o12M3yPrz/j6f9ZiJmZvhvEM0ATf8x888u89ECnWLomcUAb83mjgURjJR
An7eyfqPgH6rpdY1F5j4schc/nAYAY/kXlkSDkykhuptCA0lwGbK6Sj9BBPP
JWbbVoUQwLpdY9p8gImHX57qMQ4moJjpZ9SjyMSIs2G/7wcQ4PpAGfqlmeho
cTVjzp8ABecOvWExJmqK16c7kk5eunvvpAATvfVEi/X8CLB6N7B7epGB/oE0
6uvrBKzOTNSa/cHAEv6T2hqkQw2m1HlDDAz+9UZb5xoBumvSt/P3MHAz04xB
8yVgpstCdTmXgRPJtuW2pF388hTX0hkYpnmBdsuHAFkTu60iNQyMpml8UiP9
QVxITryUgdu+CpzleBNwpMRZSuYZA880nU7aRVowQmyTfBoDr5UWmE1cJYCw
pG5USmKgVPqDf3NJB8peFVONY+CB6SXf3Ehrf5XboB7FwNEVrf1apKeq2cKa
wQz8oDAGS0i/iA1Zq+3LwHZ/daH2KwSc/0d9ta4HA48pR0I+aWnVbiEDZ/L7
9rYO3CTN/XlrxT5HBho8mZ29RDqeoStw0IaBC+bv/U6QNk0a4zc9wsDi5Q7u
+0kvu5DMd+QgAxtvX3inTbpG6xDP0oCsN5abu4P0df7Z3ye0Gch8cHdGjbRm
69Nfp9QZqKMV+non6Yn043MOSgxc3hQyokvayYDbXiLNQJuC3HVmpNs/nny1
SoyB4wcp2WdImwR03Tm7moFutyZfBJOuknR0L1/KwMJjFrJZpDXK+kyFf9Mx
59iSFY2kn9qcU3aZpuMBle1OC6QlfgwJ1IzR0db+6/b//6/YuxcHRD/R0f/o
JQ8v0nyan2vdOuk4Y0ZVLCHtzXZPI1ro+DRYwppHetRjKkCSQcfuuZvzR8j9
sl9z9ZRXDR2P5+lsekaanfdDm/GGjnOeJiVLyf02Nr0uKlNAx8E/3HoX0tui
g1oaUuko+/6H234yL2mKfAXyd+l4SYAxX0FahBoe4xdDRxqRIvT/vM3z3Tjw
lx8dhbypeSZkHj3SV24N9qJjw2l7ow+k+/Vv83Fc6BjY6PPPFTLPLP/EynAb
OmoHjsqVknk3kBRLeW9Bx8xNj9hnyP549faBr8YBOkqOhgqKBhLwcObRzh4t
OkbYBUrEBpH94/H8uc56Omr+jH7PIvuvZ7VqZLwgHdX1N0y/IPvTKi//7Mgf
GlYoCz1OCCf7YbRY+v4kDalnWwqvkP0sdLbq7lQDDfNi5j5FkPMgkA8uH6LQ
UHj5qsLkm2Q+0+qOpFXQMIpdIVYSQ0BnF13IPJeG3xmRVTxynuScaA15HkW+
b98bPZBAgNTMcQdeELm+2cQxtbtkHhO5uid8aGiqiDVB98h8tXT94D9Pw9kp
k9ua5HwzOTzs5mhEw2sDf8QmHhEwovfbVmyBiixofp+eS+6fmtcGvhkqSh6O
UNxDztNRmaHm8c9UNNlbZ9qeT5qv5UBtFxVXLaYqypLzeJSapeVWScUt2Qp7
eKXkPDU3XVfnT0XLvMHUdhppfWTlXaEiteDLVD0578fVd0UluVJxx2yEOq2e
gM/CMotudlRMSBVzaSLPi4n2b+PiulQMF1wcUeASMGmfQr/0i4KjvqkLUyOk
LdaG236jIM/I3ezAOGmDCP19YxSk/BpKSJ8g4Kuse8nG9xR88+iukDN5vk0N
GmYRZRQ8+8u8Rvc3AdOXRoMkrlPQI0hPeJkweb4H7tlNnSWwkOkxJmVAgSL9
UPaSSQLHeHfNvI0o4MpjusEQgX/1q7W9M6ZAb4hdVkUbgW0TsbbZZuR5Gh60
rriIwGGtGJuMUxRIvUEZe+xKoIToFZ2vvhQwvHc07VpPHX6S3T3+s5QC89bJ
Om84dVj40sVsTyUFSsQ+tU831mFUPvwMRAqoPLiyyqOyDiuks3RkmBQQeXj/
+vnkOgzqvhpY9p4CQ+ldVpZWdbh6f84qC/I+E5PnsmIbvRZtY2bjeeZU6NPf
H5ZQXYt6Y3bRwlZU0GbL/J4rqUV9OdMXKrZU6J/hTFKf1KJAgLb/5TNU0DEw
5jqG1WKO2J4ztr7k/Yktm52oV4spWXH7gjKpEDvxOnLmAqLLLa2FvYtU2Lve
za/OGlEoJfyp5lIaDO6Wd4/bjyiRcuKRlhAN/g6Jt1aWQxR8wQk2E6PB+Hr3
rfYfa3BNv6Vamxp5H92jVEexqsHC7tEt+51oIBCevJAI1Whd4Fifz6IBy2xX
fvSOauTr1U3f3EqDODH2P4FbqvForODX+A4aiOeuqLzwpwqVf7T9iRukgTLb
128vVuG5JWmLnTwamMucmO02qMKONRSF7F10SKxYP6VsUIkeBgMDW7PpIPM9
ZqBGrxwffrH9MpLCABv7ZqtT28qxyEbL8EUWA+7Q1hPfJcuxZ3DzJe88BvAl
J2coz5XhFL3PSraaAf16zxwSi8swrUDTl9vHgOdRdR0XlMqwO9Kzt0qFCRqb
fjasFn6Loo/r/a/XMcHI6EKJ3UAJ6gvPFr8XZEHi0du9Um0lyCnibekXYcGg
w5uVvUQJZoiUJX6TYkGUv8CZc1kluCvI84biThawXmevuXSmBN++Vad+OsUC
a6Vh56De19ifd3ImL58FzqtcJDO6XmFNz5vUGNsGiOVcDB5qK0Klzj3z0UQj
GHq+2IrFuehtHBDN/dgCgV+sZO6uzcSFlp1GjA+tsH4qVTyGl4CHyq7fd+lu
g8KrT6bvlCZgcINwVetwG5jNvWi+75GAHkqz12GqDSJ55VGZPfE4/rA8S3Fp
O3yTLPpyOegOmh3L2y6l0g61x5ULWxZjcHrvlE2BTzs4MCR23OKFIfX0TRmN
9RxIav5rJMkjDP91aG3j28wBNkc7PasnFP07pFXbFThwg5kr4x0UgjlFm/8L
38sBW3753tZFf9RNabBYOM2BGR8Rp9u8y3ixq1bW+iUHLv6nwX7a44UH45Ur
DpZzoFTxcej1IE/kbTPJ1KVwIPK0mBF30RV3ilZXKXZwQL5NgEjgncH89DDu
0j8c2NAXYRwWdBqthlvifwtyoV9yYVnvoh2+u3359bQIF0JuT0Q+5FniTJex
VrcSFx7F1cdOLZqi+8F7qi0aXNDhr1iTzzNCKc+ekGpdLhR8tpZu4e3E5qv9
as+MuZA1Xu7dFG1Zk5L0PiPiCBf+B5vnEHQ=
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV13k4VVsUAHCzRhnKUyFz1FNRhMpOKGMhqSRUMj2SiqKumTIlkVKJJFGR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      "]]}}, {{{InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          StyleBox[
           SubscriptBox["\[Tau]", "e"],
           FontSize->12], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.5",
            FontSize->12], 
           StyleBox["  ",
            FontSize->12], 
           StyleBox["ms",
            FontSize->12], " "}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {-0.23240362811791404`, 2.097505668934243}, {Left, Baseline},
       Alignment->{Left, Top}], InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          StyleBox[
           SubscriptBox["\[Tau]", "d"],
           FontSize->12], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.8",
            FontSize->12], 
           StyleBox["  ",
            FontSize->12], 
           StyleBox["ms",
            FontSize->12], " "}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {-0.23816326530612209`, 1.7086167800453547`}, {Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      RowBox[{"\[Theta]", "=", 
       RowBox[{"-", "1"}]}], {-0.1876643990929705, 2.5833333333333344`}, {
      Left, Baseline},
      Alignment->{Left, Top}]}, {InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.05",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.8645351473922898, 0.40646258503401667`}, {Left, Baseline},
      Alignment->{Left, Top}], 
     {AbsoluteThickness[2], StrokeForm[RGBColor[0, 0, 1]], EdgeForm[RGBColor[
      0., 0., 0.]], EdgeForm[None], 
      LineBox[{{-0.9742284521686191, 
       0.4695850660641203}, {-0.9009290923775887, 0.4740093721037739}}]}, {
      InsetBox[
       StyleBox[
        TagBox[
         RowBox[{
          SubscriptBox[
           StyleBox["v",
            FontFamily->"Arial",
            FontSize->12,
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontVariations->{"StrikeThrough"->False,
            "Underline"->False}], 
           RowBox[{"r", " "}]], 
          StyleBox["=",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["0.2",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["mV",
             FontSize->12], 
            StyleBox["/",
             FontSize->12], 
            StyleBox["s",
             FontSize->12], " "}]}]}],
         "RawBoxes"],
        FontFamily->"Arial",
        FontSize->10,
        Background->GrayLevel[
         1.]], {-0.8568820861678001, 0.06632653061224714}, {Left, Baseline},
       Alignment->{Left, Top}], 
      {AbsoluteThickness[2], StrokeForm[RGBColor[1, 0.501961, 0.752941]], 
       EdgeForm[RGBColor[0., 0., 0.]], EdgeForm[None], 
       LineBox[{{-0.9665753909441297, 
        0.1294490116423508}, {-0.8932760311530991, 0.1338733176820044}}]}}}}, {
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.46314423885666633`, 
      0.6217105015264854}, {-0.6566032101954963, 1.2441888607539622`}}]}, 
    {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
     Arrowheads[{{0.042072662838444415`, 1, {
         GraphicsBox[{
           EdgeForm[None], 
           Dashing[{}], 
           PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
     StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
     0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
     AbsoluteThickness[2]}], EdgeForm[None], 
     ArrowBox[{{-0.49375648375462566`, 
      1.4890574403019987`}, {-0.3028617135968569, 0.8530323981689318}}]}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-0.5, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9201997255095663`*^9, 3.920199730277776*^9}, {
  3.920200685836291*^9, 3.9202006891264515`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "=", 
    RowBox[{"-", "1"}]}], ";", " ", 
   RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
   RowBox[{"\[Tau]d", "=", "0.1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Aeq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh4", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uv1", "]"}], "\[Equal]", "Av1"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh5", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", "Av2"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh6", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"io1", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<V (V)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
         ",", "\"\<\>\""}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", 
           ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
          "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Gray"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io1", ",", "gh5", ",", "gh6", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5"}], ",", "3"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960421970504*^9}, 3.90696058512084*^9, {
   3.9069606314181366`*^9, 3.906960643357847*^9}, {3.9069606827315874`*^9, 
   3.9069606842067842`*^9}, {3.9069607800459027`*^9, 3.906960789339467*^9}, {
   3.906960946958927*^9, 3.906961015693834*^9}, {3.9069610665773287`*^9, 
   3.9069610942448244`*^9}, {3.906975980921613*^9, 3.906976089812361*^9}, {
   3.9069761287780294`*^9, 3.9069761444527407`*^9}, {3.9069761802392483`*^9, 
   3.9069764111837945`*^9}, {3.9069764723969927`*^9, 
   3.9069764965177555`*^9}, {3.9069765456510816`*^9, 3.906976559809983*^9}, {
   3.9069766596602173`*^9, 3.9069766598802757`*^9}, 3.9069767005917444`*^9, {
   3.906976778520788*^9, 3.906976842147175*^9}, {3.90697690958217*^9, 
   3.906976948797903*^9}, {3.906977008286579*^9, 3.9069770258571725`*^9}, {
   3.9069783088004336`*^9, 3.9069783295883393`*^9}, {3.9069784555681205`*^9, 
   3.9069784736312475`*^9}, {3.9069785149274707`*^9, 
   3.9069785203580103`*^9}, {3.9069785545147533`*^9, 
   3.9069786442875185`*^9}, {3.9069786792021737`*^9, 
   3.9069788093775425`*^9}, {3.906978853786457*^9, 3.906978872127804*^9}, {
   3.906978907937706*^9, 3.9069789439029903`*^9}, {3.906979021341509*^9, 
   3.9069791012891383`*^9}, {3.9069793249639287`*^9, 
   3.9069793698176155`*^9}, {3.9069794500914555`*^9, 
   3.9069794867247863`*^9}, {3.9069795534312057`*^9, 3.906979579384478*^9}, {
   3.9069796794955473`*^9, 3.906979691967578*^9}, {3.90697984152462*^9, 
   3.9069798495662622`*^9}, {3.9069798829331303`*^9, 3.906979892303535*^9}, {
   3.906979929815036*^9, 3.9069799897806015`*^9}, {3.907029838923909*^9, 
   3.9070298429045696`*^9}, 3.907029873049452*^9, {3.9070299082271347`*^9, 
   3.9070299615551324`*^9}, {3.9070300098261147`*^9, 3.907030048469262*^9}, {
   3.907030090835805*^9, 3.907030236396055*^9}, {3.9070302925336046`*^9, 
   3.907030304052057*^9}, {3.907030372815591*^9, 3.9070304865078115`*^9}, {
   3.907030557887286*^9, 3.9070305689133244`*^9}, {3.9070308911683903`*^9, 
   3.907030892187997*^9}, {3.9070604376835546`*^9, 3.907060445993576*^9}, {
   3.9070605369359646`*^9, 3.907060610391075*^9}, {3.9070607652596164`*^9, 
   3.907060779428796*^9}, {3.90706081432941*^9, 3.9070608151924467`*^9}, {
   3.9070608516888237`*^9, 3.907060854768076*^9}, {3.907060944967448*^9, 
   3.907060990845777*^9}, {3.907061076512681*^9, 3.9070611086597958`*^9}, {
   3.9070611484876804`*^9, 3.9070611988926153`*^9}, {3.9070612582075396`*^9, 
   3.907061352628416*^9}, {3.9070614831261873`*^9, 3.9070615845827394`*^9}, {
   3.907061784180231*^9, 3.9070618159858637`*^9}, {3.907061890477336*^9, 
   3.907061943454452*^9}, {3.9071484650166793`*^9, 3.90714866651295*^9}, {
   3.907148762155178*^9, 3.9071488404975348`*^9}, {3.9071488774252872`*^9, 
   3.9071489294181747`*^9}, {3.9071489765577335`*^9, 3.907148976814991*^9}, {
   3.9071491725272875`*^9, 3.907149241274995*^9}, 3.9071493285419173`*^9, {
   3.9071493746789184`*^9, 3.907149483905308*^9}, {3.9071495447705164`*^9, 
   3.907149550473424*^9}, {3.9071495819630795`*^9, 3.90714963340366*^9}, {
   3.9071497225947556`*^9, 3.9071497240775113`*^9}, {3.907149760297258*^9, 
   3.907149761731573*^9}, {3.9071498152856555`*^9, 3.907149875310998*^9}, 
   3.9071499205002947`*^9, {3.9071499577662582`*^9, 3.9071499702396035`*^9}, {
   3.9071500532046795`*^9, 3.9071500682462764`*^9}, {3.907218618548807*^9, 
   3.9072187011296597`*^9}, {3.9072195014873066`*^9, 
   3.9072195025316906`*^9}, {3.90721955313033*^9, 3.907219605997478*^9}, {
   3.9076388883376904`*^9, 3.907639028857774*^9}, {3.9076584642948866`*^9, 
   3.9076584677515554`*^9}, 3.9076585061822867`*^9, {3.9076585847633705`*^9, 
   3.9076586673533773`*^9}, {3.9076587071776705`*^9, 3.907658763185525*^9}, {
   3.907658814220379*^9, 3.9076588335250573`*^9}, {3.907658905205724*^9, 
   3.907658950762456*^9}, {3.907660119522422*^9, 3.9076601635769453`*^9}, 
   3.9126500418645983`*^9, {3.912650272877923*^9, 3.9126503212520823`*^9}, {
   3.912650484389138*^9, 3.912650572012165*^9}, {3.912650656766632*^9, 
   3.9126506581126027`*^9}, {3.9126507259529123`*^9, 3.912650777581822*^9}, 
   3.912651074711319*^9, {3.9126512031248045`*^9, 3.912651213319991*^9}, 
   3.912651703687234*^9, {3.912770083842639*^9, 3.9127701076862574`*^9}, {
   3.9128202786546226`*^9, 3.912820284120411*^9}, 3.9128203334420757`*^9, {
   3.9128203658705187`*^9, 3.91282056892971*^9}, {3.912820649630741*^9, 
   3.912820661602646*^9}, {3.9128206955003443`*^9, 3.912820724768431*^9}, 
   3.9128207658429365`*^9, {3.9128210569191675`*^9, 3.9128210648083296`*^9}, 
   3.9128210964617248`*^9, 3.9128211283606553`*^9, 3.9128212232449136`*^9, 
   3.912821276435539*^9, 3.9128214180597515`*^9, {3.912821544243472*^9, 
   3.9128215499947147`*^9}, {3.9128217996313906`*^9, 
   3.9128218286437273`*^9}, {3.912821877012741*^9, 3.912821923396287*^9}, {
   3.9128219675831423`*^9, 3.9128221124228954`*^9}, {3.912920245593502*^9, 
   3.912920245966591*^9}, {3.9139445874276905`*^9, 3.91394459507491*^9}, {
   3.9139450187138863`*^9, 3.9139450343858995`*^9}, {3.913945205447682*^9, 
   3.913945248472603*^9}, {3.913945412690005*^9, 3.9139455155179462`*^9}, {
   3.913958962378629*^9, 3.9139589785035114`*^9}, {3.9139590402712264`*^9, 
   3.9139590937141848`*^9}, 3.9139750141153145`*^9, {3.9139750744801207`*^9, 
   3.9139751224167085`*^9}, {3.9139752153934174`*^9, 3.91397523521216*^9}, {
   3.9139752681667395`*^9, 3.9139752765309496`*^9}, {3.9139754210256305`*^9, 
   3.91397543855688*^9}, {3.913975474761815*^9, 3.913975549799944*^9}, {
   3.9139756202766843`*^9, 3.913975621473342*^9}, {3.913976355232353*^9, 
   3.9139763564720173`*^9}, 3.913976468052901*^9, {3.913976504313478*^9, 
   3.9139766047022376`*^9}, {3.9139768730666857`*^9, 
   3.9139769991515765`*^9}, {3.9139805364785786`*^9, 
   3.9139805578142247`*^9}, {3.9143020649613595`*^9, 3.914302072021001*^9}, {
   3.914302194959444*^9, 3.914302202483561*^9}, {3.9191390449333115`*^9, 
   3.919139125489049*^9}, {3.9191391862084427`*^9, 3.919139212733096*^9}, {
   3.9191393296015463`*^9, 3.9191393355361643`*^9}, {3.919139393908128*^9, 
   3.9191394603885593`*^9}, 3.919139538292508*^9, {3.9191395898427453`*^9, 
   3.9191395945714526`*^9}, {3.9191397104148407`*^9, 3.9191397261812196`*^9}, 
   3.919139790543318*^9, 3.919139967192321*^9, {3.9191406455936623`*^9, 
   3.919140690845147*^9}, {3.9191407735213203`*^9, 3.9191407743776417`*^9}, {
   3.9191408181117997`*^9, 3.9191408270078845`*^9}, {3.9191408657281303`*^9, 
   3.919140902915256*^9}, {3.9191410060045266`*^9, 3.9191410203172483`*^9}, 
   3.919141070320388*^9, {3.919141163927287*^9, 3.9191411872159586`*^9}, {
   3.9191412577972193`*^9, 3.9191412976368313`*^9}, {3.9191688870873775`*^9, 
   3.919168933052214*^9}, {3.9201182584505105`*^9, 3.920118274636175*^9}, {
   3.9201183148461*^9, 3.920118343218148*^9}, {3.9201792697127*^9, 
   3.920179337060371*^9}, {3.920179374212452*^9, 3.920179400344658*^9}, {
   3.9201794569014792`*^9, 3.920179487538362*^9}, {3.92017952752343*^9, 
   3.920179632661135*^9}, {3.920179687305022*^9, 3.92017976326361*^9}, {
   3.9201798316074123`*^9, 3.9201798667633142`*^9}, {3.9201798998755927`*^9, 
   3.9201799158641057`*^9}, {3.920179953776236*^9, 3.9201799981623473`*^9}, {
   3.9201805316932325`*^9, 3.9201805494027853`*^9}, {3.9201860831182747`*^9, 
   3.9201861551547318`*^9}, 3.920186314100003*^9, 3.920186350665934*^9, {
   3.9201987605778465`*^9, 3.920198842313061*^9}, {3.9201988946130877`*^9, 
   3.9201989974218063`*^9}, {3.9201990338435297`*^9, 
   3.9201990430735903`*^9}, {3.920199690212242*^9, 3.9201996916760683`*^9}, {
   3.920200804471526*^9, 3.920200816376642*^9}, {3.9202009061806207`*^9, 
   3.920200923775221*^9}, {3.9202011376567793`*^9, 3.9202011413270454`*^9}, {
   3.9202016208705463`*^9, 3.920201621495303*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[1], LineBox[CompressedData["
1:eJwlxQ040wkcwHEmJkUqL1vqLJK3ylLoTb9/HXde7lS7clLSC4ooL02FkktE
SopVo4SMXEkYJy+/P7b1wiamFu6cKSJSus67ubvnvs/zeb5LDx5n+VKUlJQ8
//Xf/0+d7Gl6T+fEMYnHrom2G6eoZPZZQ8HjX5jEwRs6QeFjVPI+m1slPssk
BKvM2wc/U8k5baE31U4yiXgvVmmbnEr+puk5FXmYSWhV3jtSUk8la2uORrCd
mMTicOdmv3gqeW6lbWSOBpOwG7yWLdaikqpRrt1thlbEJuZY9I7ZamQvsch5
u85KooRR722uq0reF2ZwXW0tCd+sup0NJrPIjrVaCeqB5kTP6dRYYyMVcmuT
NU8aZ0rIFA1lTVYUcmj/R3ao2IS40fHK2NpcmeyLW6A3NGlMXHPS4e0zVSKT
jrQK7AkjQlEfvKsmSIG122TmuYUMgs3zarX0mcLXjtvOjs//hpDIdT22nJlA
TZXce+fpBsRtezu1gcwx/DHOm6nlQiNmO0+bK3NH0N+MeuDJHl3C4+EVFpZ9
RaV1qc/WVy8gHGoFn/sLvmCftOfrJnVtgvf3oYr8/M/YrmaSL6XOIVpVb2sa
XvuIzsU7UxS31AhOdOV1YUw/Dp0pDlxvQCGW/BpsXFXWgz/fUToeGjIFnTbH
71ziyrE4bDTUuv4r6Kmc+13NuANrr7EMw+iDQAFXg/5ZHXjm+9KtFR8G4GOE
nmdDbzuqjbr706sGQPDlgSy5oB2XZudOmHoPQGh3WwvNuh3dV5AvonkfoKl2
zXOLLW1of3rA23RDP1w8957v5i1D3y/zFUJ2L0xOuyVz0qVo4dEUZbpVDl2x
J9I+RUjx5U+T25foy0E0h5vu5CnFZdtdzewGu+AqvSdvgiZFsenobhmnC5bb
RJL7OC1oUTV3L7fjT9gRmDe8PKUZteMXc3c5/gFu/Jm8Y5pNqE50UhxZb4Be
71LKaJSgw3s9l1LVN/DuZRrZkijBS6m1109UyOD0oGWbrboEMWN9Qv9SGdwz
9tCYoYhRW5FVVjjyCiZSigKTx15g+hzaq9FHUsg7dmB10VsRJhUxE8ueSeDK
e8fN5TwRhhyWS6huEgjfb+Fa4y/ClmJ2/bRUDA6sv3waPwmRTSbbd8gbocvm
ws2+SQEucJwvZqs2AH06f4ahU4+MhfdYykFPQSn88lwzWR22a/h+1JoWQd9Q
CN2KW4cB88oNmi+LoKxrwxp7Rh2ucJW0nnwsBJag0W/3ilrc+NIsOFhZALr6
8nTjhBpc5Vp/f7WQhHfqBfzV82pQfH78OeMACcUToU2QVo2virKtSicR3Dpn
qezNqsKQ7IwLh8JqIC7XLCC14gmu2tnLcwmvhLE1wetUP5ThJs7h4EQxH0Qm
61kLg8vw1pB5tx+DD6n6lMClI3yUNYd76rNLYfXk9Ux7Ch89aXWV6stKIKCu
XC18UQl6yVtLhDeLoDxLcV+cVoi5Wk/fEqI8uKIr/FLCe4gVX9M80x/zwC/h
0kZu+QOc0u/MdMrKBd0QmtivrQAPxEd+eHs5B8II688zi/Ow+t3dvoxNmeBS
OraudyUPa0a6+l7vvQ1GZhjTuDkXW1QeRWvHp0PzvB8W3tqfgxZXC8d9Jm7A
vpqGQB+nTLxpOBXFP5QCmjwPBTPgNhZY096N85Oh6nJP8vSldBxmly6nVSfB
Iq+ZYk7TDaySO/Xsp8XDc4ckh0PDachxzrE5eSwWTq2gv7ZamIp2idtiFV0x
8HrSevyZ+1Vkd/ofPb8lAjSeRutaDifhKf8ojbBuNhzh3FonWJuAGy4GvDn1
PAREviV7vE5dwNGMEJXNo0fB2EZ8dqQyBv27hUeCFD5AmS351nAmEpPX+tnN
hHhBdZ5y4o64E5jSqBOcH8mC4aSAu1SDABx2+i7LC7fCy9Sc3W9Y7iibMGmx
HF0G+REdUQPH9TDMSO/uKoZw8z/Z+OD0
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk01N//B3CR0iJLKRRJUn1Eu5LlnVJR1KdJabG2fX0kovjIh5ClskbI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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nk8VdsXAPB7Tyi8JE8ioSShgVe4ZDhbaKBkiPAj6aFokJAkGTKEBiKp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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.24788435240912832`, 2.1357709750566927`}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.1",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.25364398959733636`, 1.7468820861678043`}, {Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"-", "1"}]}], {-0.20314512338418478`, 2.621598639455784}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.4",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.29073015739779007`, 1.4141156462585078`}, {Left, Baseline},
      Alignment->{Left, Top}]}, {
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.5092372080458397, 
       0.48990778043805117`}, {-0.7026961793846697, 1.112386139665528}}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.539849452943799, 
       2.0205200253360127`}, {-0.35235604333024784`, 
       1.2994609695975043`}}]}}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-0.5, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.92020163724945*^9, 3.9202016569865985`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[1], LineBox[CompressedData["
1:eJwlxQ040wkcwHEmJkUqL1vqLJK3ylLoTb9/HXde7lS7clLSC4ooL02FkktE
SopVo4SMXEkYJy+/P7b1wiamFu6cKSJSus67ubvnvs/zeb5LDx5n+VKUlJQ8
//Xf/0+d7Gl6T+fEMYnHrom2G6eoZPZZQ8HjX5jEwRs6QeFjVPI+m1slPssk
BKvM2wc/U8k5baE31U4yiXgvVmmbnEr+puk5FXmYSWhV3jtSUk8la2uORrCd
mMTicOdmv3gqeW6lbWSOBpOwG7yWLdaikqpRrt1thlbEJuZY9I7ZamQvsch5
u85KooRR722uq0reF2ZwXW0tCd+sup0NJrPIjrVaCeqB5kTP6dRYYyMVcmuT
NU8aZ0rIFA1lTVYUcmj/R3ao2IS40fHK2NpcmeyLW6A3NGlMXHPS4e0zVSKT
jrQK7AkjQlEfvKsmSIG122TmuYUMgs3zarX0mcLXjtvOjs//hpDIdT22nJlA
TZXce+fpBsRtezu1gcwx/DHOm6nlQiNmO0+bK3NH0N+MeuDJHl3C4+EVFpZ9
RaV1qc/WVy8gHGoFn/sLvmCftOfrJnVtgvf3oYr8/M/YrmaSL6XOIVpVb2sa
XvuIzsU7UxS31AhOdOV1YUw/Dp0pDlxvQCGW/BpsXFXWgz/fUToeGjIFnTbH
71ziyrE4bDTUuv4r6Kmc+13NuANrr7EMw+iDQAFXg/5ZHXjm+9KtFR8G4GOE
nmdDbzuqjbr706sGQPDlgSy5oB2XZudOmHoPQGh3WwvNuh3dV5AvonkfoKl2
zXOLLW1of3rA23RDP1w8957v5i1D3y/zFUJ2L0xOuyVz0qVo4dEUZbpVDl2x
J9I+RUjx5U+T25foy0E0h5vu5CnFZdtdzewGu+AqvSdvgiZFsenobhmnC5bb
RJL7OC1oUTV3L7fjT9gRmDe8PKUZteMXc3c5/gFu/Jm8Y5pNqE50UhxZb4Be
71LKaJSgw3s9l1LVN/DuZRrZkijBS6m1109UyOD0oGWbrboEMWN9Qv9SGdwz
9tCYoYhRW5FVVjjyCiZSigKTx15g+hzaq9FHUsg7dmB10VsRJhUxE8ueSeDK
e8fN5TwRhhyWS6huEgjfb+Fa4y/ClmJ2/bRUDA6sv3waPwmRTSbbd8gbocvm
ws2+SQEucJwvZqs2AH06f4ahU4+MhfdYykFPQSn88lwzWR22a/h+1JoWQd9Q
CN2KW4cB88oNmi+LoKxrwxp7Rh2ucJW0nnwsBJag0W/3ilrc+NIsOFhZALr6
8nTjhBpc5Vp/f7WQhHfqBfzV82pQfH78OeMACcUToU2QVo2virKtSicR3Dpn
qezNqsKQ7IwLh8JqIC7XLCC14gmu2tnLcwmvhLE1wetUP5ThJs7h4EQxH0Qm
61kLg8vw1pB5tx+DD6n6lMClI3yUNYd76rNLYfXk9Ux7Ch89aXWV6stKIKCu
XC18UQl6yVtLhDeLoDxLcV+cVoi5Wk/fEqI8uKIr/FLCe4gVX9M80x/zwC/h
0kZu+QOc0u/MdMrKBd0QmtivrQAPxEd+eHs5B8II688zi/Ow+t3dvoxNmeBS
OraudyUPa0a6+l7vvQ1GZhjTuDkXW1QeRWvHp0PzvB8W3tqfgxZXC8d9Jm7A
vpqGQB+nTLxpOBXFP5QCmjwPBTPgNhZY096N85Oh6nJP8vSldBxmly6nVSfB
Iq+ZYk7TDaySO/Xsp8XDc4ckh0PDachxzrE5eSwWTq2gv7ZamIp2idtiFV0x
8HrSevyZ+1Vkd/ofPb8lAjSeRutaDifhKf8ojbBuNhzh3FonWJuAGy4GvDn1
PAREviV7vE5dwNGMEJXNo0fB2EZ8dqQyBv27hUeCFD5AmS351nAmEpPX+tnN
hHhBdZ5y4o64E5jSqBOcH8mC4aSAu1SDABx2+i7LC7fCy9Sc3W9Y7iibMGmx
HF0G+REdUQPH9TDMSO/uKoZw8z/Z+OD0
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVk3c41v/3x5GkoQh98ikqJJJRSUl5UdLOHg2zkq8KDYWMQrLvt03Knrd5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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1Xk0VtsbB/D3PYgky1RplCGRilKmytmiuCiRea5rzniRTPEqZEoiZCaU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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.26769274376417274`, 2.2165532879818612`}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.1",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.2734523809523808, 1.8276643990929728`}, {Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"-", "1"}]}], {-0.2229535147392292, 2.7023809523809526`}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.2",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.3105385487528345, 1.4948979591836764`}, {Left, Baseline},
      Alignment->{Left, Top}]}, {
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.49843335450292503`, 
       0.7407581205741036}, {-0.691892325841755, 1.3632364798015804`}}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.5290455994008844, 
       1.608105059349617}, {-0.33815082924311557`, 0.97208001721655}}]}}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{41., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-0.5, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.920201156924296*^9, 3.9202011658327565`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "=", "1"}], ";", " ", 
   RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
   RowBox[{"\[Tau]d", "=", "0.8"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Aeq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh4", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uv1", "]"}], "\[Equal]", "Av1"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh5", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", "Av2"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh6", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"io1", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<V (V)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
         ",", "\"\<\>\""}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", 
           ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
          "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Gray"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io1", ",", "gh5", ",", "gh6", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "0"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960421970504*^9}, 3.90696058512084*^9, {
   3.9069606314181366`*^9, 3.906960643357847*^9}, {3.9069606827315874`*^9, 
   3.9069606842067842`*^9}, {3.9069607800459027`*^9, 3.906960789339467*^9}, {
   3.906960946958927*^9, 3.906961015693834*^9}, {3.9069610665773287`*^9, 
   3.9069610942448244`*^9}, {3.906975980921613*^9, 3.906976089812361*^9}, {
   3.9069761287780294`*^9, 3.9069761444527407`*^9}, {3.9069761802392483`*^9, 
   3.9069764111837945`*^9}, {3.9069764723969927`*^9, 
   3.9069764965177555`*^9}, {3.9069765456510816`*^9, 3.906976559809983*^9}, {
   3.9069766596602173`*^9, 3.9069766598802757`*^9}, 3.9069767005917444`*^9, {
   3.906976778520788*^9, 3.906976842147175*^9}, {3.90697690958217*^9, 
   3.906976948797903*^9}, {3.906977008286579*^9, 3.9069770258571725`*^9}, {
   3.9069783088004336`*^9, 3.9069783295883393`*^9}, {3.9069784555681205`*^9, 
   3.9069784736312475`*^9}, {3.9069785149274707`*^9, 
   3.9069785203580103`*^9}, {3.9069785545147533`*^9, 
   3.9069786442875185`*^9}, {3.9069786792021737`*^9, 
   3.9069788093775425`*^9}, {3.906978853786457*^9, 3.906978872127804*^9}, {
   3.906978907937706*^9, 3.9069789439029903`*^9}, {3.906979021341509*^9, 
   3.9069791012891383`*^9}, {3.9069793249639287`*^9, 
   3.9069793698176155`*^9}, {3.9069794500914555`*^9, 
   3.9069794867247863`*^9}, {3.9069795534312057`*^9, 3.906979579384478*^9}, {
   3.9069796794955473`*^9, 3.906979691967578*^9}, {3.90697984152462*^9, 
   3.9069798495662622`*^9}, {3.9069798829331303`*^9, 3.906979892303535*^9}, {
   3.906979929815036*^9, 3.9069799897806015`*^9}, {3.907029838923909*^9, 
   3.9070298429045696`*^9}, 3.907029873049452*^9, {3.9070299082271347`*^9, 
   3.9070299615551324`*^9}, {3.9070300098261147`*^9, 3.907030048469262*^9}, {
   3.907030090835805*^9, 3.907030236396055*^9}, {3.9070302925336046`*^9, 
   3.907030304052057*^9}, {3.907030372815591*^9, 3.9070304865078115`*^9}, {
   3.907030557887286*^9, 3.9070305689133244`*^9}, {3.9070308911683903`*^9, 
   3.907030892187997*^9}, {3.9070604376835546`*^9, 3.907060445993576*^9}, {
   3.9070605369359646`*^9, 3.907060610391075*^9}, {3.9070607652596164`*^9, 
   3.907060779428796*^9}, {3.90706081432941*^9, 3.9070608151924467`*^9}, {
   3.9070608516888237`*^9, 3.907060854768076*^9}, {3.907060944967448*^9, 
   3.907060990845777*^9}, {3.907061076512681*^9, 3.9070611086597958`*^9}, {
   3.9070611484876804`*^9, 3.9070611988926153`*^9}, {3.9070612582075396`*^9, 
   3.907061352628416*^9}, {3.9070614831261873`*^9, 3.9070615845827394`*^9}, {
   3.907061784180231*^9, 3.9070618159858637`*^9}, {3.907061890477336*^9, 
   3.907061943454452*^9}, {3.9071484650166793`*^9, 3.90714866651295*^9}, {
   3.907148762155178*^9, 3.9071488404975348`*^9}, {3.9071488774252872`*^9, 
   3.9071489294181747`*^9}, {3.9071489765577335`*^9, 3.907148976814991*^9}, {
   3.9071491725272875`*^9, 3.907149241274995*^9}, 3.9071493285419173`*^9, {
   3.9071493746789184`*^9, 3.907149483905308*^9}, {3.9071495447705164`*^9, 
   3.907149550473424*^9}, {3.9071495819630795`*^9, 3.90714963340366*^9}, {
   3.9071497225947556`*^9, 3.9071497240775113`*^9}, {3.907149760297258*^9, 
   3.907149761731573*^9}, {3.9071498152856555`*^9, 3.907149875310998*^9}, 
   3.9071499205002947`*^9, {3.9071499577662582`*^9, 3.9071499702396035`*^9}, {
   3.9071500532046795`*^9, 3.9071500682462764`*^9}, {3.907218618548807*^9, 
   3.9072187011296597`*^9}, {3.9072195014873066`*^9, 
   3.9072195025316906`*^9}, {3.90721955313033*^9, 3.907219605997478*^9}, {
   3.9076388883376904`*^9, 3.907639028857774*^9}, {3.9076584642948866`*^9, 
   3.9076584677515554`*^9}, 3.9076585061822867`*^9, {3.9076585847633705`*^9, 
   3.9076586673533773`*^9}, {3.9076587071776705`*^9, 3.907658763185525*^9}, {
   3.907658814220379*^9, 3.9076588335250573`*^9}, {3.907658905205724*^9, 
   3.907658950762456*^9}, {3.907660119522422*^9, 3.9076601635769453`*^9}, 
   3.9126500418645983`*^9, {3.912650272877923*^9, 3.9126503212520823`*^9}, {
   3.912650484389138*^9, 3.912650572012165*^9}, {3.912650656766632*^9, 
   3.9126506581126027`*^9}, {3.9126507259529123`*^9, 3.912650777581822*^9}, 
   3.912651074711319*^9, {3.9126512031248045`*^9, 3.912651213319991*^9}, 
   3.912651703687234*^9, {3.912770083842639*^9, 3.9127701076862574`*^9}, {
   3.9128202786546226`*^9, 3.912820284120411*^9}, 3.9128203334420757`*^9, {
   3.9128203658705187`*^9, 3.91282056892971*^9}, {3.912820649630741*^9, 
   3.912820661602646*^9}, {3.9128206955003443`*^9, 3.912820724768431*^9}, 
   3.9128207658429365`*^9, {3.9128210569191675`*^9, 3.9128210648083296`*^9}, 
   3.9128210964617248`*^9, 3.9128211283606553`*^9, 3.9128212232449136`*^9, 
   3.912821276435539*^9, 3.9128214180597515`*^9, {3.912821544243472*^9, 
   3.9128215499947147`*^9}, {3.9128217996313906`*^9, 
   3.9128218286437273`*^9}, {3.912821877012741*^9, 3.912821923396287*^9}, {
   3.9128219675831423`*^9, 3.9128221124228954`*^9}, {3.912920245593502*^9, 
   3.912920245966591*^9}, {3.9139445874276905`*^9, 3.91394459507491*^9}, {
   3.9139450187138863`*^9, 3.9139450343858995`*^9}, {3.913945205447682*^9, 
   3.913945248472603*^9}, {3.913945412690005*^9, 3.9139455155179462`*^9}, {
   3.913958962378629*^9, 3.9139589785035114`*^9}, {3.9139590402712264`*^9, 
   3.9139590937141848`*^9}, 3.9139750141153145`*^9, {3.9139750744801207`*^9, 
   3.9139751224167085`*^9}, {3.9139752153934174`*^9, 3.91397523521216*^9}, {
   3.9139752681667395`*^9, 3.9139752765309496`*^9}, {3.9139754210256305`*^9, 
   3.91397543855688*^9}, {3.913975474761815*^9, 3.913975549799944*^9}, {
   3.9139756202766843`*^9, 3.913975621473342*^9}, {3.913976355232353*^9, 
   3.9139763564720173`*^9}, 3.913976468052901*^9, {3.913976504313478*^9, 
   3.9139766047022376`*^9}, {3.9139768730666857`*^9, 
   3.9139769991515765`*^9}, {3.9139805364785786`*^9, 
   3.9139805578142247`*^9}, {3.9143020649613595`*^9, 3.914302072021001*^9}, {
   3.914302194959444*^9, 3.914302202483561*^9}, {3.9191390449333115`*^9, 
   3.919139125489049*^9}, {3.9191391862084427`*^9, 3.919139212733096*^9}, {
   3.9191393296015463`*^9, 3.9191393355361643`*^9}, {3.919139393908128*^9, 
   3.9191394603885593`*^9}, 3.919139538292508*^9, {3.9191395898427453`*^9, 
   3.9191395945714526`*^9}, {3.9191397104148407`*^9, 3.9191397261812196`*^9}, 
   3.919139790543318*^9, 3.919139967192321*^9, {3.9191406455936623`*^9, 
   3.919140690845147*^9}, {3.9191407735213203`*^9, 3.9191407743776417`*^9}, {
   3.9191408181117997`*^9, 3.9191408270078845`*^9}, {3.9191408657281303`*^9, 
   3.919140902915256*^9}, {3.9191410060045266`*^9, 3.9191410203172483`*^9}, 
   3.919141070320388*^9, {3.919141163927287*^9, 3.9191411872159586`*^9}, {
   3.9191412577972193`*^9, 3.9191412976368313`*^9}, {3.9191688870873775`*^9, 
   3.919168933052214*^9}, {3.9201182584505105`*^9, 3.920118274636175*^9}, {
   3.9201183148461*^9, 3.920118343218148*^9}, {3.9201792697127*^9, 
   3.920179337060371*^9}, {3.920179374212452*^9, 3.920179400344658*^9}, {
   3.9201794569014792`*^9, 3.920179487538362*^9}, {3.92017952752343*^9, 
   3.920179632661135*^9}, {3.920179687305022*^9, 3.92017976326361*^9}, {
   3.9201798316074123`*^9, 3.9201798667633142`*^9}, {3.9201798998755927`*^9, 
   3.9201799158641057`*^9}, {3.920179953776236*^9, 3.9201799981623473`*^9}, {
   3.9201805316932325`*^9, 3.9201805494027853`*^9}, {3.9201860831182747`*^9, 
   3.9201861551547318`*^9}, 3.920186314100003*^9, 3.920186350665934*^9, {
   3.9201987605778465`*^9, 3.920198842313061*^9}, {3.9201988946130877`*^9, 
   3.9201989974218063`*^9}, {3.9201990338435297`*^9, 
   3.9201990430735903`*^9}, {3.920199690212242*^9, 3.9201996916760683`*^9}, {
   3.920200804471526*^9, 3.920200816376642*^9}, {3.9202009061806207`*^9, 
   3.920200923775221*^9}, {3.9202011376567793`*^9, 3.9202011413270454`*^9}, {
   3.9202012267021785`*^9, 3.920201296629879*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[1], LineBox[CompressedData["
1:eJwlxQ04E3gAx3EmJkVvXrbUWUneKktJb0qOOy93ql11UtILilRemgoll4iU
FKtGCRm5XoRxwn5/bOuFTUwt3DlTRKR0nXdzd899n+fzfBfsP8bypaioqHj+
67//nybprH9P58QyyWO3hFXrxqkk64yR8PEvTLL/uu6RsGEqucfmVkjOMIlw
mXlL32cqmdYcckPjBJPEebGKmxVU8pu253jEQSbRKb97qKiGSqoEh8PZzkwy
L8ylwS+OSs4uXRWRrcUktn1XsyQ6VKIe6dbRbGRF1jOHo7ZO1SBd9nNdtugu
JUWMGm9zPXVyT5TOdVtlSXwzq7fVmkwhrSt14jUDzUnnqZQY44VqxKHemieL
NSVyZW1JvRWF9O/9yA6RmJDrra+Mrc1VSXfsbP3+MWNy1VmXt8dUhSQeahLa
2S8kypqg7YIjSlRtlpvnPGQQNs+rydJnHK+dNp8ZmfUNkSr0PDadHoW2Ws7d
c3RDcsvOVqM3Yxg/xnozdVxpZKrLhLkqdxD+ZtR9T3bpEY8Hl1ko+QqV1SnP
1lTOJo5Vws89+V/QLev8ul5zJuH9faAsL+8zWjRM8mTUaaRJ/Za20dWPcCnc
lqy8qUE4UeXXRNE96D9dGLjGkELm/xpkXFHSiZ9vqxwLCR5Hm82x2xe5ChSG
DoVY13yFvtrZ3zWMW1F1lWUUSu8DZaObYc+UVpz+vtih7EMvPobre9Z2tUBj
aIc/vaIXwi/35Un5LViQlTNq6t2LkI7mRpp1C3YsIS+ieB9QX7XiucWmZtid
6vU2XduDC2ff89295fD9MkspYndhbMI9iZMmg4VHfaSpgwLtMcdTP4XL8PKn
sS3zDRQQT+OmOXvKsGiLm5ltXzuu0DtzR2kySEyHdso57VhsE0H2cBphUTF9
N7f1T2wNzB1YnNyAmXHzuNud/oA7fzL3qHY9NO3bKE6sN6DXuBYz6qRwfK/v
Wqz+Bu9eppLGBCkuplRdO14mx6k+y+ZVmlIgfU18zwI57hp7aE1SJJipzCx5
OPgKo8kFgUnDL5A2jfZq6JEMuUf3LS94K0ZiATOh5JkUl987bSjliRF8UCGl
uksRttfCTeAvRmMhu2ZCJoEj6y+fuk8isEmSXauiDu025290jwkx22mWhK1e
C/pE3iRDtwaMOXdZqkeeQiXs0nQzeTVatHw/6kyI0d0fTLfiViNgRqlhwyUx
StrXrrBjVGOJm7TpxGMRWMI6v51LqrDupVlQkKoQegaKNON4AZa51dxbLiJ4
p5nPXz5DAMm5keeMfQSFoyH1G1Mr8aogy6p4DHBvm6K2O7MCwVnp5w+EChCb
YxaQUvYEy7Z18VzDyjG8Imi1+ocSrOccDEqQ8CE2WcOaE1SCm/3mHX4MPlIM
KIELBvmQN4R5GrCLsXzsWoYdhQ9PWnW55qIiBFSXaoTNLYKXoqlIdKMApZnK
e5LUh8jRefrWXpyLy3qiL0W8Byj7muqZ9pgHv/iL67il9zFu0JbhnJkDvWCa
xK85H/viIj68vZSNUHvrz5PzclH57k53+voMuBYPr+5ayoNgsL379e5bWGiG
6LoNOWhUexQ1My4NDTN+mHNzbzYsrjwc8Rm9jj2C2kAf5wzcMBqP5B9IhjbP
Q8kMuIV8a9q7EX4SKi51Jk1cTMMAu3gxrTIRc70mCzn111GhcO7cS4vDc8dE
xwMDqeC4ZNucOBqDk0vor63mpMA2YXOMsj0ar8esR57tuAJ2m//hc5vCofU0
Ss9yIBEn/SO1QjvYOMS5uVq4Mh5rLwS8Ofk8GGLfol1eJ89jKD1YbcPQYRjb
SM4MlkfDv0N06IjSB5Sp0m+NJiOQtNLPdjLYC5W5qglbY48juU43KC+ChYHE
gDtUwwAMOH+X6QUHvEzJ3vmGtQPyUZNGy6FFyAtvjew9po/Qhfp3ljFEgn8A
NloOAw==
      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1Xk0VH0YB3CVSlkiKlJIkRYtCikkVAoVWVK2KK2WpN0aSdZSlpCtbJV1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      "]]}}, {{}, {}, 
    {RGBColor[1, 0.5, 0.5], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV1nc4V/0bB3CUhiKjhIbVQElJSZlRihZZyUgkWnhKkjKSEflJpJK0yBbq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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.2732647188378008, -2.0271157343974093`}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.8",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.27902435602600884`, -2.4160046232862977`}, {
        Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"+", "1"}]}], {-0.1967233696715145, -1.6321512704021546`}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.2",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.31611052382646254`, -2.748771063195594}, {Left, Baseline},
      Alignment->{Left, Top}]}, {
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.5040053295765531, -0.640720089084319}, \
{-0.6868635942016019, -1.1843194683727427`}}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.478080472001014, -1.5300616914496432`}, \
{-0.2659842884156835, -0.924289661396946}}]}}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox["\"V (V)\"", FontSize -> 20, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {51., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-3., 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9202013036047754`*^9, 3.920201350291889*^9}, {
  3.9202013812901816`*^9, 3.9202013862988615`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "=", "1"}], ";", " ", 
   RowBox[{"\[Tau]e", "=", "0.5"}], ";", 
   RowBox[{"\[Tau]d", "=", "0.1"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vr", "=", "0.4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", 
        RowBox[{"Aeq", "[", "uvH", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh4", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Pink"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", " ", "\[Tau]d"}], " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uv1", "]"}], "\[Equal]", "Av1"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av2", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uvH", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh5", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Tau]d", " ", "vr", " ", 
         RowBox[{
          RowBox[{"A", "'"}], "[", "u", "]"}]}], " ", "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", "3"}], "N0", "  ", 
          RowBox[{"Abs", "[", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox[
              RowBox[{"EV", "-", "u"}], "kT"], ")"}], 
            RowBox[{"3", "/", "2"}]], "  ", "]"}]}], "-", 
         RowBox[{"A", "[", "u", "]"}]}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"A", "[", "uvH", "]"}], "\[Equal]", "Av2"}]}], "}"}], ",", 
     RowBox[{"{", "A", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"Av1", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{"A", "[", "uv1", "]"}], "]"}], "/.", "sol"}], "}"}], "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"gh6", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Evaluate", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Theta]"}], " ", "L", " ", 
             RowBox[{
              RowBox[{"A", "[", "u", "]"}], "/", "\[Tau]e"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"f", "/", "\[Tau]d"}], 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Aeq", "[", "u", "]"}], "-", 
               RowBox[{"A", "[", "u", "]"}]}], ")"}]}]}], "}"}], "/.", 
          "sol"}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "uvH", ",", "uv1"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Blue"}], "}"}],
          "}"}]}], ",", 
       RowBox[{"BaseStyle", "->", 
        RowBox[{"{", 
         RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<u\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
          RowBox[{"Style", "[", 
           RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(tot\)]\)\>\"", ",", 
            RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
          ",", "\"\<\>\""}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}]}], "]"}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"io1", "=", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"Idc", "[", "uv", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"uv", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10000"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(u\), \(g\)]\) (V)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", 
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SubscriptBox[\(I\), \(d\)]\) (\[Mu]A)\>\"", ",", 
           RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}], ",", "\"\<\>\"", 
         ",", "\"\<\>\""}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "0.5"}], ",", "0", ",", "0.5", ",", "1", ",", "2", 
           ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
          "}"}], ",", "None", ",", "None"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", "Gray"}], "}"}], 
        "}"}]}], ",", 
      RowBox[{"LabelStyle", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ")"}]}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "0.7"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"90", " ", "4`"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"io1", ",", "gh5", ",", "gh6", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"uv0", ",", "uv1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "0.1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"BaseStyle", "->", 
    RowBox[{"{", 
     RowBox[{"FontSize", "\[Rule]", "16"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.8390646611298313`*^9, 3.839064663549252*^9}, {
   3.8390651628201227`*^9, 3.8390651698744855`*^9}, {3.8390671245340233`*^9, 
   3.839067253968177*^9}, {3.8390672908692884`*^9, 3.8390673435588245`*^9}, {
   3.839067444277615*^9, 3.8390674530816755`*^9}, {3.839067483223913*^9, 
   3.8390676448632746`*^9}, {3.839067792030848*^9, 3.8390679296503277`*^9}, {
   3.839068035965031*^9, 3.8390681198292847`*^9}, {3.8390709139116144`*^9, 
   3.8390709421089935`*^9}, {3.83907099038449*^9, 3.8390709930117693`*^9}, {
   3.839071053413534*^9, 3.839071065617492*^9}, {3.839071142245447*^9, 
   3.8390712315177836`*^9}, {3.839071262559967*^9, 3.8390713000871944`*^9}, {
   3.8390714971122246`*^9, 3.839071517359198*^9}, {3.8390715485300074`*^9, 
   3.8390716200472517`*^9}, {3.8390716672806673`*^9, 3.839071782347397*^9}, {
   3.839071837937226*^9, 3.839071939311781*^9}, {3.839072168081314*^9, 
   3.839072168581891*^9}, {3.8390723168444653`*^9, 3.8390724465495067`*^9}, {
   3.8390724871236815`*^9, 3.839072628537404*^9}, {3.8390726857581015`*^9, 
   3.83907270608572*^9}, {3.8390728526632924`*^9, 3.8390730714112225`*^9}, {
   3.839082271666379*^9, 3.8390823055073657`*^9}, {3.839082353119522*^9, 
   3.839082449840514*^9}, {3.8390839765348864`*^9, 3.839084057466158*^9}, {
   3.8390840878065057`*^9, 3.8390841778809776`*^9}, {3.8390842363292522`*^9, 
   3.8390842982497163`*^9}, 3.83908433029414*^9, {3.8390843708346243`*^9, 
   3.8390844315092807`*^9}, 3.839084462612833*^9, {3.8390845298830824`*^9, 
   3.839084537171591*^9}, {3.8390846234607463`*^9, 3.839084639769829*^9}, {
   3.839085385972989*^9, 3.8390853976007433`*^9}, {3.8390854555897675`*^9, 
   3.839085524444199*^9}, {3.839085565738154*^9, 3.8390855920819826`*^9}, {
   3.8390863447286386`*^9, 3.839086474045252*^9}, {3.839086860852067*^9, 
   3.839086874816577*^9}, {3.839087637034748*^9, 3.8390876843714943`*^9}, 
   3.83908780285631*^9, 3.8390878367914057`*^9, {3.839088015231053*^9, 
   3.8390880802460375`*^9}, {3.839088241208177*^9, 3.839088251058446*^9}, 
   3.839088396382834*^9, 3.8391182307918463`*^9, {3.839118379381566*^9, 
   3.8391183868618546`*^9}, {3.839118542781612*^9, 3.839118576690755*^9}, {
   3.839119230679368*^9, 3.8391192435152392`*^9}, {3.8391193005384474`*^9, 
   3.839119322077612*^9}, {3.8391197370496492`*^9, 3.839119744561663*^9}, {
   3.839119780647091*^9, 3.8391198576053133`*^9}, {3.83913747847266*^9, 
   3.839137485481214*^9}, {3.8391375587687283`*^9, 3.8391375797199593`*^9}, {
   3.8391376276780567`*^9, 3.8391376620779104`*^9}, {3.83913835785732*^9, 
   3.839138374216883*^9}, 3.8391384110040264`*^9, {3.8391384624942074`*^9, 
   3.839138462879356*^9}, {3.8391385170099597`*^9, 3.839138536349577*^9}, {
   3.839139183554804*^9, 3.8391391930138044`*^9}, {3.8391393033973885`*^9, 
   3.8391393043613095`*^9}, 3.839139359067504*^9, 3.839139436240513*^9, {
   3.8392078031308994`*^9, 3.8392078143543434`*^9}, {3.8392078889566584`*^9, 
   3.83920790820275*^9}, {3.839208054761527*^9, 3.839208093399903*^9}, {
   3.8392084092575808`*^9, 3.8392084620514746`*^9}, 3.839208533536579*^9, {
   3.8392086070037084`*^9, 3.8392086083290124`*^9}, 3.8392086479255266`*^9, {
   3.8392225965883913`*^9, 3.8392226283136573`*^9}, {3.8392226646362276`*^9, 
   3.8392227421040397`*^9}, 3.8392227767756677`*^9, {3.8392228326927814`*^9, 
   3.839222892911393*^9}, 3.8392230743763013`*^9, {3.839223141092394*^9, 
   3.839223141783134*^9}, 3.839223177642132*^9, {3.8392232273840017`*^9, 
   3.8392232854596047`*^9}, {3.8392233573873816`*^9, 3.839223398790718*^9}, {
   3.8392234505961695`*^9, 3.839223507183962*^9}, {3.839223811017748*^9, 
   3.8392239510950837`*^9}, {3.8392240167007127`*^9, 3.839224025275307*^9}, {
   3.8392241057509785`*^9, 3.839224157437503*^9}, {3.839224200897134*^9, 
   3.8392242487597456`*^9}, {3.839224294917468*^9, 3.839224296013791*^9}, {
   3.8392243639841394`*^9, 3.8392243950383773`*^9}, 3.839224442185709*^9, {
   3.8392245129185476`*^9, 3.8392245373577056`*^9}, {3.8392245776385975`*^9, 
   3.839224740679908*^9}, {3.8392248367057567`*^9, 3.839224838004247*^9}, {
   3.8392249023255987`*^9, 3.8392249329681873`*^9}, 3.8392250078513308`*^9, {
   3.8392250461420965`*^9, 3.8392250567765236`*^9}, {3.8392250892690206`*^9, 
   3.839225128234888*^9}, {3.839225292837965*^9, 3.8392253052980237`*^9}, {
   3.839225374465659*^9, 3.839225378163327*^9}, {3.8392366608564453`*^9, 
   3.839236691352835*^9}, {3.839236736346908*^9, 3.8392367461057377`*^9}, {
   3.8392368452896976`*^9, 3.8392369245276327`*^9}, {3.8392369586763678`*^9, 
   3.839236989556669*^9}, {3.8392370210310707`*^9, 3.839237025639107*^9}, {
   3.8392370611832547`*^9, 3.839237143422812*^9}, {3.839237229917989*^9, 
   3.839237306453603*^9}, {3.8392373387206373`*^9, 3.839237342820054*^9}, {
   3.839237447098841*^9, 3.8392375543643665`*^9}, {3.8392411494009237`*^9, 
   3.839241171431179*^9}, {3.83924120627816*^9, 3.8392412247291117`*^9}, 
   3.8392412792201967`*^9, 3.8392413874247665`*^9, {3.8392415172512045`*^9, 
   3.8392415791894693`*^9}, {3.839241632182249*^9, 3.8392416472548246`*^9}, 
   3.8392418101230965`*^9, {3.839242047805271*^9, 3.8392420951804295`*^9}, {
   3.8392421670049934`*^9, 3.8392422247577305`*^9}, {3.8392422574679546`*^9, 
   3.8392422587095203`*^9}, {3.839242291908*^9, 3.8392425704347763`*^9}, {
   3.8392426617662134`*^9, 3.8392426717163734`*^9}, 3.839242785862258*^9, {
   3.839246817917405*^9, 3.8392468269690895`*^9}, {3.839246889891876*^9, 
   3.839246924816616*^9}, {3.839309996677757*^9, 3.839310018708186*^9}, {
   3.839310845764266*^9, 3.839310880859878*^9}, {3.839310926113166*^9, 
   3.839310949193386*^9}, {3.8393110019361973`*^9, 3.8393110308399534`*^9}, {
   3.8393270934512377`*^9, 3.839327332415727*^9}, {3.839327370226597*^9, 
   3.839327451303669*^9}, {3.8393275031436253`*^9, 3.8393275194960613`*^9}, {
   3.839327586008069*^9, 3.8393276948310633`*^9}, {3.8393278034898295`*^9, 
   3.8393278068680096`*^9}, {3.8393278450424776`*^9, 
   3.8393278797618237`*^9}, {3.8393289610021143`*^9, 3.839328976754302*^9}, {
   3.8393294967878103`*^9, 3.839329617607455*^9}, 3.8393297021511583`*^9, {
   3.839329736764967*^9, 3.83932973839811*^9}, {3.839329841358012*^9, 
   3.839329850076448*^9}, {3.8393298856244183`*^9, 3.83932990739045*^9}, {
   3.839330200791801*^9, 3.839330209464896*^9}, 3.83933026862875*^9, {
   3.8393304947792683`*^9, 3.839330614321838*^9}, {3.839330707456501*^9, 
   3.8393307223587484`*^9}, {3.8393307586469154`*^9, 3.839330774655125*^9}, {
   3.8393308208469334`*^9, 3.8393308254369345`*^9}, {3.83933092079788*^9, 
   3.8393310148602314`*^9}, {3.8393311745075006`*^9, 
   3.8393311994275675`*^9}, {3.8393312620131807`*^9, 
   3.8393312886598005`*^9}, {3.83933158528376*^9, 3.8393316720258255`*^9}, 
   3.8393317188850336`*^9, {3.8393317973728094`*^9, 3.8393319397094903`*^9}, 
   3.8393320294844685`*^9, {3.8393325727147913`*^9, 3.8393326007437224`*^9}, {
   3.839332643937569*^9, 3.8393326886712303`*^9}, {3.839332884251463*^9, 
   3.8393328849388123`*^9}, {3.8393329498885293`*^9, 3.839332954368989*^9}, 
   3.839332984548478*^9, {3.839333161836732*^9, 3.839333179429063*^9}, {
   3.839333212168277*^9, 3.8393332158859396`*^9}, {3.839333299885914*^9, 
   3.839333320058819*^9}, {3.8393333662749724`*^9, 3.839333389618166*^9}, 
   3.8393335815372777`*^9, {3.8393336646381135`*^9, 3.839333690640252*^9}, {
   3.839333816187891*^9, 3.839333852596138*^9}, {3.839333913143673*^9, 
   3.839333960953573*^9}, {3.8393340547869487`*^9, 3.839334137419753*^9}, {
   3.839420765475212*^9, 3.839420767706482*^9}, {3.839420800720344*^9, 
   3.83942080814257*^9}, {3.839420930166752*^9, 3.839420954611184*^9}, 
   3.839421093306271*^9, {3.839421249787591*^9, 3.8394213460868835`*^9}, {
   3.839421400152422*^9, 3.8394214417353144`*^9}, {3.839421483648677*^9, 
   3.839421580608614*^9}, 3.839421616079374*^9, 3.839422181142932*^9, {
   3.8394224472930202`*^9, 3.839422448371497*^9}, {3.8394225405886507`*^9, 
   3.839422541885687*^9}, {3.8394225839963813`*^9, 3.83942258751882*^9}, 
   3.8394239784679832`*^9, {3.8394240190394516`*^9, 3.8394240194005165`*^9}, {
   3.839481241680246*^9, 3.8394812636526537`*^9}, {3.8394813033197775`*^9, 
   3.839481343020226*^9}, {3.8394813886318493`*^9, 3.83948138904453*^9}, {
   3.8394814470082235`*^9, 3.8394815138762083`*^9}, {3.839484145142799*^9, 
   3.8394841575703464`*^9}, {3.8394842427712455`*^9, 
   3.8394842456191454`*^9}, {3.8394844396674995`*^9, 
   3.8394844660440836`*^9}, {3.8394845806487627`*^9, 3.83948460808449*^9}, {
   3.8394847191879005`*^9, 3.839484719920673*^9}, {3.8394847985864277`*^9, 
   3.8394847999498053`*^9}, {3.839485522225484*^9, 3.8394858614478054`*^9}, {
   3.8394858968609977`*^9, 3.8394858979280567`*^9}, {3.83950394022218*^9, 
   3.839504016595684*^9}, {3.839504079022719*^9, 3.8395041716366367`*^9}, {
   3.8395042475063295`*^9, 3.83950424807436*^9}, {3.8395043044033585`*^9, 
   3.8395043325148754`*^9}, {3.839504403912784*^9, 3.839504405955762*^9}, {
   3.839504461254238*^9, 3.8395044954062967`*^9}, {3.839504572085556*^9, 
   3.8395046258331623`*^9}, {3.839504718095887*^9, 3.839504733043982*^9}, {
   3.839504792704324*^9, 3.8395048214714227`*^9}, {3.8395048602645364`*^9, 
   3.839504871422516*^9}, {3.83950521161292*^9, 3.8395052235501237`*^9}, {
   3.839505255990897*^9, 3.8395052773582516`*^9}, {3.839505321851119*^9, 
   3.839505332451271*^9}, {3.8395054257374*^9, 3.8395054385582395`*^9}, 
   3.839505580972617*^9, {3.8395057025144815`*^9, 3.8395057031788645`*^9}, {
   3.8395057369934807`*^9, 3.8395057373979363`*^9}, {3.839505772294227*^9, 
   3.839505778367197*^9}, {3.83950673092721*^9, 3.8395067795192204`*^9}, {
   3.8395084122279215`*^9, 3.8395084138977666`*^9}, {3.839508448233049*^9, 
   3.8395084493422976`*^9}, {3.839508499051385*^9, 3.8395085344200335`*^9}, 
   3.8395086207285233`*^9, {3.8395086973952723`*^9, 3.8395086978689127`*^9}, {
   3.8395089696790757`*^9, 3.839509039224576*^9}, {3.8395100524490423`*^9, 
   3.839510053723009*^9}, {3.839511493807127*^9, 3.8395115089839754`*^9}, {
   3.8395115931589155`*^9, 3.839511633911852*^9}, {3.839511664551564*^9, 
   3.8395117021779413`*^9}, {3.839511738662855*^9, 3.8395117683886237`*^9}, {
   3.8395840465025244`*^9, 3.8395840478719764`*^9}, {3.8395842326636224`*^9, 
   3.8395842405526743`*^9}, {3.8395844072352886`*^9, 3.839584438590257*^9}, {
   3.839584539157859*^9, 3.839584558647271*^9}, {3.8395846133789663`*^9, 
   3.83958465811094*^9}, {3.839584785836444*^9, 3.839584807986281*^9}, 
   3.839586726652771*^9, {3.8395867995416994`*^9, 3.8395868420413933`*^9}, 
   3.83958688638865*^9, {3.839587244941451*^9, 3.83958726487414*^9}, {
   3.83958774293878*^9, 3.8395877838602095`*^9}, 3.839587828597546*^9, {
   3.839587879706158*^9, 3.8395879135449758`*^9}, {3.839587955043039*^9, 
   3.8395879642045746`*^9}, {3.8395880048781385`*^9, 3.839588051406326*^9}, {
   3.8395880883490973`*^9, 3.8395881594520197`*^9}, {3.8395882347911615`*^9, 
   3.8395883226336384`*^9}, 3.8395883559509153`*^9, 3.839588415451826*^9, {
   3.8395884902783833`*^9, 3.8395885216082554`*^9}, {3.8395941073926105`*^9, 
   3.8395942227438965`*^9}, 3.839595304916483*^9, {3.8395954862576475`*^9, 
   3.83959557521957*^9}, {3.839595607221432*^9, 3.8395956076140194`*^9}, {
   3.839595660820343*^9, 3.839595661835729*^9}, {3.839604650775865*^9, 
   3.8396046640054827`*^9}, {3.839604708532463*^9, 3.8396047629301977`*^9}, {
   3.839604795558606*^9, 3.839604808947177*^9}, {3.839604852056878*^9, 
   3.8396048690185547`*^9}, {3.839642088079403*^9, 3.839642141004441*^9}, {
   3.8396422800918975`*^9, 3.8396423077286944`*^9}, {3.8396424143783884`*^9, 
   3.8396424152236857`*^9}, {3.8396426095904264`*^9, 
   3.8396426100591545`*^9}, {3.8396426843268356`*^9, 3.8396426912164164`*^9}, 
   3.8396427676568155`*^9, {3.8396428549330425`*^9, 3.8396429650459213`*^9}, 
   3.839643049962629*^9, {3.839643091872772*^9, 3.8396431410841303`*^9}, 
   3.839643491656567*^9, {3.839643550041149*^9, 3.839643610060313*^9}, {
   3.8396436783391447`*^9, 3.8396437059963512`*^9}, {3.8396437389632745`*^9, 
   3.8396437448257093`*^9}, {3.839643793497415*^9, 3.8396438275668716`*^9}, {
   3.839643978745996*^9, 3.8396439798436737`*^9}, {3.839644021519642*^9, 
   3.8396440428152156`*^9}, {3.8396441695399504`*^9, 
   3.8396441971715937`*^9}, {3.839644230142295*^9, 3.8396442469945946`*^9}, {
   3.839644284692358*^9, 3.8396442961501245`*^9}, {3.8396443434969287`*^9, 
   3.8396443583914576`*^9}, {3.8396448346105194`*^9, 3.839644913123821*^9}, {
   3.8396555898716025`*^9, 3.839655650012109*^9}, {3.8396556822310605`*^9, 
   3.839655771771843*^9}, {3.839655952479162*^9, 3.8396559541084647`*^9}, 
   3.839656003389371*^9, {3.8396560347174463`*^9, 3.839656116850046*^9}, {
   3.8396562422855325`*^9, 3.8396562713341274`*^9}, 3.8396563271846943`*^9, {
   3.8396565529884825`*^9, 3.839656667985509*^9}, {3.8396568526250334`*^9, 
   3.839656873162519*^9}, {3.8396570321068354`*^9, 3.8396570367161813`*^9}, {
   3.8396571621919303`*^9, 3.839657193340761*^9}, {3.839657225174745*^9, 
   3.8396572442512493`*^9}, {3.8396572932236905`*^9, 3.8396572940165*^9}, 
   3.8396574072631903`*^9, {3.8396575476060143`*^9, 3.8396575682943974`*^9}, {
   3.839664138921971*^9, 3.839664156869915*^9}, 3.839664243007531*^9, {
   3.839669622125418*^9, 3.839669647884663*^9}, {3.839670002387182*^9, 
   3.839670025487237*^9}, {3.8396700586539392`*^9, 3.8396701085420904`*^9}, {
   3.8396766028729286`*^9, 3.839676603372811*^9}, {3.839676649783103*^9, 
   3.8396766681979322`*^9}, {3.839723206211033*^9, 3.839723252419324*^9}, {
   3.8397243192805915`*^9, 3.8397243622670403`*^9}, {3.839724526690404*^9, 
   3.8397245565593586`*^9}, 3.839724591814554*^9, {3.8397246526353917`*^9, 
   3.8397246677187424`*^9}, {3.839724698665658*^9, 3.8397248461537275`*^9}, {
   3.839724910156172*^9, 3.839724969029936*^9}, {3.839725029399225*^9, 
   3.839725070375955*^9}, {3.8397257491640964`*^9, 3.8397258148584566`*^9}, {
   3.839726205531111*^9, 3.839726226304987*^9}, {3.839726314389023*^9, 
   3.8397264887181263`*^9}, {3.8397266355093994`*^9, 
   3.8397266356472826`*^9}, {3.839727069639051*^9, 3.83972707062368*^9}, {
   3.8397274615058823`*^9, 3.839727481527841*^9}, {3.83972755827617*^9, 
   3.8397275594724007`*^9}, {3.839727857737072*^9, 3.83972788618902*^9}, 
   3.8397281801577473`*^9, {3.839741406815917*^9, 3.839741648719699*^9}, 
   3.839741694966459*^9, {3.8397417738301263`*^9, 3.8397417740488653`*^9}, 
   3.839742014559319*^9, {3.8397421882027674`*^9, 3.839742188943444*^9}, {
   3.8397589658528605`*^9, 3.83975903164762*^9}, {3.839759582024466*^9, 
   3.8397596437148447`*^9}, {3.8397597378135786`*^9, 3.839759770277839*^9}, {
   3.839760042248042*^9, 3.8397600434337606`*^9}, {3.839760792865179*^9, 
   3.839760817913896*^9}, {3.8397655048182044`*^9, 3.839765505036851*^9}, {
   3.839765649791177*^9, 3.839765680039174*^9}, {3.839765730951825*^9, 
   3.8397657438209515`*^9}, {3.8397658325268707`*^9, 3.839765870890603*^9}, {
   3.8397695336031294`*^9, 3.8397695785421767`*^9}, 3.839769610638837*^9, {
   3.839769642999297*^9, 3.8397696900062704`*^9}, {3.8397697294324865`*^9, 
   3.839769753667972*^9}, 3.839770624201335*^9, {3.8399858643515997`*^9, 
   3.839985870106961*^9}, {3.8399859073530426`*^9, 3.83998590778368*^9}, {
   3.839986665758301*^9, 3.839986671600184*^9}, {3.840015477117873*^9, 
   3.840015532633871*^9}, {3.840262190474472*^9, 3.8402621922160215`*^9}, {
   3.8402622512898836`*^9, 3.8402623158498154`*^9}, {3.840262346847395*^9, 
   3.840262361938197*^9}, {3.8402624446884875`*^9, 3.840262497278998*^9}, {
   3.8402625593196363`*^9, 3.840262562846277*^9}, {3.840262654524027*^9, 
   3.8402626673364897`*^9}, {3.8402800661176753`*^9, 3.840280138278593*^9}, {
   3.840280177703832*^9, 3.840280189480773*^9}, {3.8402802324576406`*^9, 
   3.8402802331825943`*^9}, {3.8402812754975386`*^9, 3.840281326464582*^9}, 
   3.8402813946519136`*^9, {3.84028186111417*^9, 3.8402818954912634`*^9}, {
   3.8402819964993353`*^9, 3.8402819971437144`*^9}, {3.840330466229367*^9, 
   3.8403304972505484`*^9}, 3.8403305401374164`*^9, 3.840330628649666*^9, {
   3.8403306672934227`*^9, 3.8403306802026963`*^9}, {3.8403307193320885`*^9, 
   3.840330758272279*^9}, 3.8403307967908325`*^9, 3.8403308358680725`*^9, {
   3.840330872410847*^9, 3.8403308786837*^9}, {3.8403309221453967`*^9, 
   3.840330944340696*^9}, 3.840330989285677*^9, {3.840331109810131*^9, 
   3.840331153164013*^9}, {3.840331431580937*^9, 3.8403314406879196`*^9}, {
   3.8403317789283185`*^9, 3.840331780542934*^9}, {3.840331813886128*^9, 
   3.8403318320633073`*^9}, {3.8403318821336937`*^9, 
   3.8403318897950106`*^9}, {3.8403319357741313`*^9, 
   3.8403319411825953`*^9}, {3.8403320129500637`*^9, 
   3.8403321277278547`*^9}, {3.840332221075777*^9, 3.8403322212632327`*^9}, {
   3.8404162792747984`*^9, 3.8404162803058043`*^9}, {3.840416344690134*^9, 
   3.8404163448306866`*^9}, {3.8404178626090136`*^9, 3.840417925824424*^9}, {
   3.8404191918191233`*^9, 3.84041920226635*^9}, {3.840419242024495*^9, 
   3.8404192617321796`*^9}, {3.8404194389428053`*^9, 3.840419462557069*^9}, {
   3.840453834266838*^9, 3.8404538447517056`*^9}, 3.840453909614043*^9, {
   3.8404539683635793`*^9, 3.8404539905838337`*^9}, 3.8404540272985306`*^9, {
   3.840454156166298*^9, 3.840454205291971*^9}, {3.840454240247527*^9, 
   3.8404542540157146`*^9}, {3.8404543237333283`*^9, 
   3.8404543404928937`*^9}, {3.8404544521143074`*^9, 
   3.8404544541302176`*^9}, {3.840454485008524*^9, 3.8404544958331428`*^9}, {
   3.840454535970628*^9, 3.840454551137659*^9}, {3.840500625089159*^9, 
   3.840500656940725*^9}, {3.840500695345143*^9, 3.8405006960523067`*^9}, {
   3.8405010969852047`*^9, 3.840501112587641*^9}, {3.840501150634077*^9, 
   3.8405011611522417`*^9}, {3.8405026446645527`*^9, 3.84050265267775*^9}, 
   3.8405026878215275`*^9, 3.8405027886745453`*^9, {3.8405028323157024`*^9, 
   3.8405028521056433`*^9}, {3.840508597751215*^9, 3.8405086042448597`*^9}, {
   3.8405086361734276`*^9, 3.840508697640854*^9}, {3.84530515034306*^9, 
   3.8453051663199177`*^9}, 3.845305197884505*^9, {3.8454792808354254`*^9, 
   3.8454794150956697`*^9}, {3.845479722113243*^9, 3.8454797915964413`*^9}, {
   3.845514873929638*^9, 3.8455149337268724`*^9}, {3.8455149684706416`*^9, 
   3.8455149695080223`*^9}, {3.8455153275220933`*^9, 3.845515328229957*^9}, {
   3.845515395675539*^9, 3.845515401297691*^9}, {3.845515515853771*^9, 
   3.845515576447665*^9}, {3.845515612558851*^9, 3.845515632979537*^9}, {
   3.845515680153039*^9, 3.8455159262376585`*^9}, {3.845516112061887*^9, 
   3.8455161465263453`*^9}, {3.845516193085106*^9, 3.845516229178423*^9}, {
   3.8455163351689043`*^9, 3.845516585318216*^9}, {3.8455166177397394`*^9, 
   3.845516714733508*^9}, {3.845516771645197*^9, 3.8455167731827154`*^9}, {
   3.845516818729296*^9, 3.84551695860878*^9}, {3.845516994711903*^9, 
   3.845517026462266*^9}, 3.845517092145789*^9, {3.845517135366593*^9, 
   3.845517155446496*^9}, {3.845517186534149*^9, 3.8455171937276707`*^9}, {
   3.845517227012909*^9, 3.8455172279061613`*^9}, {3.8455173234132085`*^9, 
   3.8455173514857492`*^9}, {3.845517423730919*^9, 3.8455174243493695`*^9}, {
   3.8455174624069753`*^9, 3.845517465100626*^9}, 3.845517507705373*^9, 
   3.8455175508535676`*^9, {3.8455176264044795`*^9, 3.8455176334075813`*^9}, {
   3.8455313319229393`*^9, 3.845531509940443*^9}, 3.8455315849840965`*^9, {
   3.8455317016782956`*^9, 3.845531738966821*^9}, {3.845531778451456*^9, 
   3.845531779386674*^9}, {3.8456415428113813`*^9, 3.845641735457308*^9}, {
   3.8456420427094593`*^9, 3.8456420444008894`*^9}, {3.8456420953927226`*^9, 
   3.845642095827136*^9}, {3.8456421305858717`*^9, 3.8456422084386454`*^9}, 
   3.8456422719473834`*^9, {3.8456424654126687`*^9, 3.8456424685516415`*^9}, {
   3.8456425391271963`*^9, 3.845642581942461*^9}, {3.8456426396045694`*^9, 
   3.845642806094469*^9}, {3.845642836196087*^9, 3.845642900922883*^9}, {
   3.845642970285206*^9, 3.8456430181273146`*^9}, {3.8456430708546114`*^9, 
   3.845643125882959*^9}, {3.845643178575968*^9, 3.845643257358486*^9}, {
   3.8456433623862553`*^9, 3.8456433771042914`*^9}, {3.8456434590863156`*^9, 
   3.8456434937160645`*^9}, 3.845643545927831*^9, {3.845643600156926*^9, 
   3.845643618570978*^9}, {3.8456436644300175`*^9, 3.84564366503797*^9}, {
   3.845643702197648*^9, 3.8456437461979747`*^9}, 3.8456439574887114`*^9, {
   3.846069818172841*^9, 3.846069849642768*^9}, {3.8460699136765876`*^9, 
   3.846069914209477*^9}, {3.8460699599440656`*^9, 3.8460700314146757`*^9}, {
   3.846070076753316*^9, 3.846070077439046*^9}, {3.846070157661101*^9, 
   3.8460701937707815`*^9}, {3.846070258127372*^9, 3.846070370035694*^9}, 
   3.8460704231130123`*^9, {3.846070456017062*^9, 3.8460704588184586`*^9}, {
   3.8460710172041235`*^9, 3.846071021582673*^9}, {3.846071106666136*^9, 
   3.8460711227728405`*^9}, {3.846071236516765*^9, 3.8460712690613956`*^9}, {
   3.846071302508814*^9, 3.8460713286265783`*^9}, {3.846071391711331*^9, 
   3.8460713919222136`*^9}, {3.8460717432565613`*^9, 3.846071846163582*^9}, {
   3.8460718796339417`*^9, 3.8460718981181345`*^9}, {3.8460719281852317`*^9, 
   3.8460719602156863`*^9}, {3.8460725487311463`*^9, 
   3.8460727277222366`*^9}, {3.8460727966336946`*^9, 
   3.8460727999447126`*^9}, {3.8460728715731387`*^9, 3.846072900231036*^9}, 
   3.8460729488995743`*^9, 3.846073094187673*^9, {3.846073124968068*^9, 
   3.846073143649494*^9}, {3.846073291437569*^9, 3.846073320871194*^9}, {
   3.8460733513356*^9, 3.8460733827836275`*^9}, {3.8460734213260293`*^9, 
   3.846073547913215*^9}, {3.8460735888598585`*^9, 3.8460735948494663`*^9}, {
   3.8460736630482445`*^9, 3.84607366906472*^9}, {3.846073769039547*^9, 
   3.8460738022300262`*^9}, {3.8460738788770266`*^9, 
   3.8460738952181954`*^9}, {3.846073949966679*^9, 3.8460739569065495`*^9}, {
   3.846074029073464*^9, 3.8460740346596146`*^9}, {3.846074102104647*^9, 
   3.8460741324118767`*^9}, {3.8460741949049115`*^9, 3.846074222593691*^9}, {
   3.8460742841895127`*^9, 3.846074340763191*^9}, {3.846160732253354*^9, 
   3.8461607332481594`*^9}, 3.846161492762432*^9, {3.846161780897497*^9, 
   3.846161788138113*^9}, {3.8461618293598766`*^9, 3.846161858226082*^9}, {
   3.8461618966585674`*^9, 3.846161969794857*^9}, 3.846162102689354*^9, {
   3.8461621668466263`*^9, 3.846162180355235*^9}, {3.8461622164826603`*^9, 
   3.8461622355856447`*^9}, {3.846162281065609*^9, 3.8461624985309367`*^9}, 
   3.8461626621493115`*^9, 3.846162697816634*^9, {3.8461627342864695`*^9, 
   3.8461627345822268`*^9}, {3.8461628166006966`*^9, 3.8461628174265194`*^9}, 
   3.846162849529516*^9, 3.846163042718745*^9, {3.8461630926561747`*^9, 
   3.8461631014520173`*^9}, 3.846164675187914*^9, {3.8461653709571285`*^9, 
   3.8461653939322076`*^9}, {3.846239297565034*^9, 3.846239321709072*^9}, {
   3.8462393704866405`*^9, 3.846239378462596*^9}, 3.8462394463604927`*^9, {
   3.846239908200873*^9, 3.846240041118046*^9}, {3.8462400979595313`*^9, 
   3.8462402075029526`*^9}, {3.846240330599819*^9, 3.846240332116249*^9}, {
   3.846240396409835*^9, 3.846240426609739*^9}, {3.8462404635946035`*^9, 
   3.846240479194495*^9}, {3.846240547126852*^9, 3.8462406007711906`*^9}, {
   3.846240672984129*^9, 3.8462406735655537`*^9}, {3.846240715451014*^9, 
   3.846240727662325*^9}, {3.8462408398048706`*^9, 3.8462408550133176`*^9}, {
   3.846240906219432*^9, 3.8462409845731764`*^9}, {3.8462415426024213`*^9, 
   3.846241600241384*^9}, {3.8462416533016524`*^9, 3.8462416824345474`*^9}, {
   3.846241871443136*^9, 3.846241889026347*^9}, {3.84624196622915*^9, 
   3.846241982209696*^9}, {3.8462420839315395`*^9, 3.8462421106657743`*^9}, {
   3.8462493213059616`*^9, 3.846249371505189*^9}, {3.846249426216957*^9, 
   3.8462494677076874`*^9}, {3.846249549506504*^9, 3.8462495503135986`*^9}, {
   3.8463317012472258`*^9, 3.846331723789422*^9}, 3.846331790148814*^9, {
   3.846331841946804*^9, 3.8463318642788124`*^9}, {3.8463318999649568`*^9, 
   3.84633190085021*^9}, {3.846331970187175*^9, 3.8463319724350276`*^9}, {
   3.846332425994608*^9, 3.8463324267831564`*^9}, {3.8463324853767433`*^9, 
   3.846332505743512*^9}, {3.84633253640195*^9, 3.84633253746087*^9}, 
   3.8463325927468147`*^9, {3.846332664076268*^9, 3.84633267729871*^9}, {
   3.84633282094595*^9, 3.846332866648316*^9}, {3.846332915983061*^9, 
   3.846332964772069*^9}, {3.8463332315659857`*^9, 3.8463332589840655`*^9}, {
   3.8463333159368706`*^9, 3.8463333881232243`*^9}, {3.846333478174964*^9, 
   3.846333507307977*^9}, {3.8463337169753866`*^9, 3.846333752677167*^9}, {
   3.8463337874930525`*^9, 3.8463337938266315`*^9}, {3.84633382889653*^9, 
   3.8463338314544067`*^9}, {3.8463338661347585`*^9, 
   3.8463338671064034`*^9}, {3.8463341029946103`*^9, 3.8463341178046017`*^9}, 
   3.8463344961508446`*^9, {3.846334551477289*^9, 3.8463345669722776`*^9}, {
   3.846334647851037*^9, 3.8463346507709723`*^9}, {3.8463350072556896`*^9, 
   3.846335009531336*^9}, {3.8463350584383993`*^9, 3.8463350832915545`*^9}, 
   3.8463356730391445`*^9, {3.8463357330577507`*^9, 3.846335734677639*^9}, {
   3.8463357713912954`*^9, 3.846335784599365*^9}, {3.846335824451017*^9, 
   3.846335850541898*^9}, {3.8465148279290648`*^9, 3.846514905645626*^9}, {
   3.8465149546536207`*^9, 3.8465149557287645`*^9}, 3.8465150347627506`*^9, 
   3.8465150735123754`*^9, 3.846515133355834*^9, {3.846551496354246*^9, 
   3.8465515199215117`*^9}, {3.8465515514860935`*^9, 3.846551558453719*^9}, {
   3.8465516511605453`*^9, 3.8465516816971188`*^9}, {3.8465517493251767`*^9, 
   3.8465517819787836`*^9}, {3.846551812162984*^9, 3.84655181978378*^9}, {
   3.8469012753631597`*^9, 3.8469014245266294`*^9}, {3.846901477101201*^9, 
   3.846901480891117*^9}, 3.846901533852523*^9, {3.8469015653056993`*^9, 
   3.8469015942691755`*^9}, 3.8469016260053563`*^9, {3.846901664939994*^9, 
   3.8469016657155457`*^9}, {3.846901747509447*^9, 3.8469017503170366`*^9}, {
   3.84690191404624*^9, 3.84690193970901*^9}, 3.846901985149589*^9, {
   3.84690203255608*^9, 3.8469020373058805`*^9}, {3.8469021528510695`*^9, 
   3.84690220430954*^9}, {3.8469022448931456`*^9, 3.8469022504597807`*^9}, {
   3.846902285388745*^9, 3.846902288603936*^9}, {3.8469023384879513`*^9, 
   3.846902371933584*^9}, 3.846902765731144*^9, {3.8469028332433987`*^9, 
   3.8469028443561935`*^9}, 3.8469030843801355`*^9, 3.846903160980903*^9, {
   3.8469032059828815`*^9, 3.8469032390870132`*^9}, {3.84690342310567*^9, 
   3.846903439207902*^9}, {3.8469061580301685`*^9, 3.8469062645476227`*^9}, {
   3.8469065486448135`*^9, 3.846906561548581*^9}, {3.8469067471371455`*^9, 
   3.8469068174896765`*^9}, {3.84690686154051*^9, 3.8469068684523077`*^9}, {
   3.8497527618146653`*^9, 3.8497527676380615`*^9}, {3.8497528414079475`*^9, 
   3.849752843454638*^9}, {3.8497530625145917`*^9, 3.849753063032662*^9}, {
   3.8497530971084747`*^9, 3.8497531011988783`*^9}, {3.8497532258666143`*^9, 
   3.849753345755213*^9}, {3.849753924288494*^9, 3.849753985952464*^9}, {
   3.849754069460248*^9, 3.849754087001464*^9}, {3.849754259204835*^9, 
   3.849754268999332*^9}, {3.8497554284565487`*^9, 3.8497554930272894`*^9}, {
   3.849755685279069*^9, 3.8497556896240177`*^9}, {3.8497558773614607`*^9, 
   3.849755877843891*^9}, {3.8497559807269473`*^9, 3.8497560211165953`*^9}, 
   3.850443650520732*^9, {3.8504438404083548`*^9, 3.8504441120345283`*^9}, {
   3.850444156664489*^9, 3.850444280967318*^9}, {3.850444354744196*^9, 
   3.85044463643923*^9}, {3.8504447256702757`*^9, 3.8504447980665684`*^9}, {
   3.8505274395909743`*^9, 3.8505274411181674`*^9}, {3.8505275310510144`*^9, 
   3.8505276349685197`*^9}, {3.850527665564816*^9, 3.850527741150744*^9}, {
   3.850528010969228*^9, 3.8505280914370484`*^9}, {3.850528341539154*^9, 
   3.8505283435766478`*^9}, {3.850528399268195*^9, 3.850528452926201*^9}, {
   3.850528511901552*^9, 3.850528524032834*^9}, {3.8505286008142643`*^9, 
   3.8505286255862675`*^9}, {3.850528657292616*^9, 3.8505287485299587`*^9}, {
   3.850528791091945*^9, 3.8505287912193995`*^9}, {3.8505289892778673`*^9, 
   3.8505290093703814`*^9}, {3.8505291179397283`*^9, 3.850529246368305*^9}, {
   3.8505292847200036`*^9, 3.8505293531238484`*^9}, {3.85052942526715*^9, 
   3.8505295026053452`*^9}, {3.850529652810694*^9, 3.85052969888447*^9}, {
   3.8505297570230837`*^9, 3.8505297793908668`*^9}, {3.8505298130474796`*^9, 
   3.85052982372943*^9}, 3.850529903643921*^9, {3.8505299339680395`*^9, 
   3.850529938523468*^9}, {3.850533467746894*^9, 3.850533696587976*^9}, {
   3.8505337523084393`*^9, 3.8505340100220647`*^9}, {3.850534073301394*^9, 
   3.8505341115212436`*^9}, {3.8505341448690495`*^9, 3.850534244609003*^9}, {
   3.8505342773409953`*^9, 3.850534317485276*^9}, {3.850534376818581*^9, 
   3.8505345375059347`*^9}, 3.8505345895823593`*^9, {3.850534712936541*^9, 
   3.850534853983102*^9}, {3.85053489565536*^9, 3.85053490800423*^9}, {
   3.850535011630887*^9, 3.850535069369616*^9}, {3.8505609789941187`*^9, 
   3.8505609796472797`*^9}, {3.850561024378234*^9, 3.8505611077291512`*^9}, {
   3.8505611554662695`*^9, 3.8505611900834045`*^9}, {3.8505612604815354`*^9, 
   3.850561307036023*^9}, 3.8505614161973686`*^9, {3.850561489892841*^9, 
   3.8505614904828854`*^9}, 3.850561540476676*^9, {3.850566961415826*^9, 
   3.85056699607444*^9}, {3.8505670465401917`*^9, 3.850567067268143*^9}, {
   3.850567124561453*^9, 3.8505671481746936`*^9}, {3.8505671891195374`*^9, 
   3.850567192972233*^9}, {3.8505672404233675`*^9, 3.850567272319547*^9}, {
   3.8505673802869396`*^9, 3.850567388289441*^9}, {3.850567420051065*^9, 
   3.8505674379775977`*^9}, {3.850568113924102*^9, 3.850568121245113*^9}, {
   3.8505681786419373`*^9, 3.8505682190225987`*^9}, {3.8505682742836356`*^9, 
   3.8505682972999997`*^9}, {3.850568330443387*^9, 3.8505683415549088`*^9}, {
   3.850568377492758*^9, 3.850568403154665*^9}, {3.850568837097434*^9, 
   3.850568946787299*^9}, {3.8505691453292117`*^9, 3.850569195539899*^9}, {
   3.8505692859376397`*^9, 3.8505693669331837`*^9}, {3.8505693974289236`*^9, 
   3.8505695475039663`*^9}, {3.8505696079724298`*^9, 
   3.8505696221275873`*^9}, {3.8505697874854712`*^9, 
   3.8505698175396166`*^9}, {3.850569868969412*^9, 3.8505698726296372`*^9}, {
   3.850569905926787*^9, 3.8505699809036593`*^9}, {3.850570015920215*^9, 
   3.85057008172045*^9}, {3.850785556912866*^9, 3.850785616614393*^9}, {
   3.8507856606466494`*^9, 3.850785723209618*^9}, {3.8507857656066175`*^9, 
   3.850785880874487*^9}, {3.850785924508508*^9, 3.850785937300992*^9}, {
   3.8507859750545197`*^9, 3.8507859968100834`*^9}, {3.850786077342246*^9, 
   3.8507860848236823`*^9}, {3.8507861340867023`*^9, 3.8507861374599075`*^9}, 
   3.850786227982345*^9, {3.8507862859910107`*^9, 3.8507863008387175`*^9}, {
   3.850786368316942*^9, 3.850786374976062*^9}, {3.850786423270744*^9, 
   3.850786423425295*^9}, {3.8507865491264324`*^9, 3.850786595976322*^9}, {
   3.850786636570469*^9, 3.850786709325587*^9}, {3.850786743990263*^9, 
   3.8507868015086374`*^9}, {3.8507870134211025`*^9, 
   3.8507870176048164`*^9}, {3.850787059141889*^9, 3.8507870650224657`*^9}, {
   3.850787111878257*^9, 3.850787113157389*^9}, {3.8507887599989805`*^9, 
   3.850788841851822*^9}, {3.850788913491912*^9, 3.8507890311085014`*^9}, {
   3.8507890809695005`*^9, 3.8507890902738066`*^9}, {3.8507891921970196`*^9, 
   3.8507891973037043`*^9}, {3.8507892279462795`*^9, 3.850789249495205*^9}, {
   3.850791412876636*^9, 3.8507914130273633`*^9}, {3.8507915155633483`*^9, 
   3.8507915162424593`*^9}, {3.850827343188859*^9, 3.850827375432101*^9}, {
   3.8508274109868975`*^9, 3.8508274369062905`*^9}, {3.8508274890786314`*^9, 
   3.8508274894138756`*^9}, {3.8508275695516253`*^9, 3.850827569788695*^9}, 
   3.8508276711587315`*^9, {3.8508277166165743`*^9, 3.8508277728386536`*^9}, {
   3.8508278475513325`*^9, 3.8508278753498926`*^9}, {3.8508279408872223`*^9, 
   3.85082794118405*^9}, {3.850827981298354*^9, 3.850828056921221*^9}, {
   3.850828494113824*^9, 3.850828495039543*^9}, {3.85082856023905*^9, 
   3.850828575017256*^9}, {3.850828628892047*^9, 3.850828696248144*^9}, 
   3.8508287630158415`*^9, {3.8508293694951773`*^9, 3.850829372071825*^9}, {
   3.8508294221130056`*^9, 3.8508294474505587`*^9}, {3.8508295136154523`*^9, 
   3.850829546786518*^9}, {3.8508307551495695`*^9, 3.850830755305548*^9}, {
   3.850830846425475*^9, 3.8508308469949007`*^9}, {3.8508328226756153`*^9, 
   3.8508328956454206`*^9}, {3.8515151599360895`*^9, 
   3.8515151854097323`*^9}, {3.851515227511881*^9, 3.8515152691971846`*^9}, {
   3.8517376565999703`*^9, 3.851737660729647*^9}, {3.8517376993937993`*^9, 
   3.851737854226467*^9}, {3.8517379030659018`*^9, 3.851737963592141*^9}, {
   3.8517380004040184`*^9, 3.851738156849004*^9}, {3.8517381881441555`*^9, 
   3.8517383547150526`*^9}, {3.851738403578961*^9, 3.8517384750343685`*^9}, {
   3.8517386329884996`*^9, 3.8517387036807384`*^9}, {3.8517387496128297`*^9, 
   3.8517391066461697`*^9}, 3.851739167106615*^9, {3.851739199324179*^9, 
   3.8517392033202653`*^9}, {3.851739306865944*^9, 3.8517396012506447`*^9}, {
   3.8517396478337793`*^9, 3.851739717012961*^9}, {3.851739779861041*^9, 
   3.8517398251446857`*^9}, {3.8517401674121*^9, 3.85174023031291*^9}, {
   3.8517403822763968`*^9, 3.8517405215277195`*^9}, {3.8517405598035936`*^9, 
   3.8517405807347307`*^9}, 3.8517406111741548`*^9, {3.852771815388609*^9, 
   3.852771815826337*^9}, {3.852771938933034*^9, 3.852772015527173*^9}, {
   3.8527720455326405`*^9, 3.852772051655347*^9}, {3.852772112575083*^9, 
   3.85277216712604*^9}, {3.8527722639917727`*^9, 3.8527723193930345`*^9}, {
   3.8527723507994275`*^9, 3.8527724886441803`*^9}, 3.852772518958836*^9, {
   3.8527726690962496`*^9, 3.8527726724595623`*^9}, {3.852772785224839*^9, 
   3.852772814059412*^9}, {3.8527728536940055`*^9, 3.8527728543197746`*^9}, 
   3.8527728940919833`*^9, {3.8527729250196114`*^9, 3.8527729905347033`*^9}, {
   3.8527730490675783`*^9, 3.8527730529881525`*^9}, {3.852773399558672*^9, 
   3.852773411256092*^9}, {3.852773459331044*^9, 3.852773480723246*^9}, {
   3.8527735251577444`*^9, 3.8527735647772226`*^9}, {3.85277372440212*^9, 
   3.852773727144375*^9}, {3.8528731960002193`*^9, 3.8528733256878357`*^9}, {
   3.852873387704274*^9, 3.852873409884766*^9}, {3.8528734508562613`*^9, 
   3.8528734515817213`*^9}, {3.8528734901873713`*^9, 3.852873528186962*^9}, {
   3.8528735614708843`*^9, 3.8528735812376013`*^9}, {3.8528736531146784`*^9, 
   3.852873677620881*^9}, {3.8528801200331235`*^9, 3.852880146194016*^9}, {
   3.853140879673688*^9, 3.8531409143592653`*^9}, {3.8531409625201416`*^9, 
   3.8531410288764524`*^9}, {3.8531410590292354`*^9, 
   3.8531411087537766`*^9}, {3.906960081539485*^9, 3.9069602331152077`*^9}, {
   3.9069603433707557`*^9, 3.906960421970504*^9}, 3.90696058512084*^9, {
   3.9069606314181366`*^9, 3.906960643357847*^9}, {3.9069606827315874`*^9, 
   3.9069606842067842`*^9}, {3.9069607800459027`*^9, 3.906960789339467*^9}, {
   3.906960946958927*^9, 3.906961015693834*^9}, {3.9069610665773287`*^9, 
   3.9069610942448244`*^9}, {3.906975980921613*^9, 3.906976089812361*^9}, {
   3.9069761287780294`*^9, 3.9069761444527407`*^9}, {3.9069761802392483`*^9, 
   3.9069764111837945`*^9}, {3.9069764723969927`*^9, 
   3.9069764965177555`*^9}, {3.9069765456510816`*^9, 3.906976559809983*^9}, {
   3.9069766596602173`*^9, 3.9069766598802757`*^9}, 3.9069767005917444`*^9, {
   3.906976778520788*^9, 3.906976842147175*^9}, {3.90697690958217*^9, 
   3.906976948797903*^9}, {3.906977008286579*^9, 3.9069770258571725`*^9}, {
   3.9069783088004336`*^9, 3.9069783295883393`*^9}, {3.9069784555681205`*^9, 
   3.9069784736312475`*^9}, {3.9069785149274707`*^9, 
   3.9069785203580103`*^9}, {3.9069785545147533`*^9, 
   3.9069786442875185`*^9}, {3.9069786792021737`*^9, 
   3.9069788093775425`*^9}, {3.906978853786457*^9, 3.906978872127804*^9}, {
   3.906978907937706*^9, 3.9069789439029903`*^9}, {3.906979021341509*^9, 
   3.9069791012891383`*^9}, {3.9069793249639287`*^9, 
   3.9069793698176155`*^9}, {3.9069794500914555`*^9, 
   3.9069794867247863`*^9}, {3.9069795534312057`*^9, 3.906979579384478*^9}, {
   3.9069796794955473`*^9, 3.906979691967578*^9}, {3.90697984152462*^9, 
   3.9069798495662622`*^9}, {3.9069798829331303`*^9, 3.906979892303535*^9}, {
   3.906979929815036*^9, 3.9069799897806015`*^9}, {3.907029838923909*^9, 
   3.9070298429045696`*^9}, 3.907029873049452*^9, {3.9070299082271347`*^9, 
   3.9070299615551324`*^9}, {3.9070300098261147`*^9, 3.907030048469262*^9}, {
   3.907030090835805*^9, 3.907030236396055*^9}, {3.9070302925336046`*^9, 
   3.907030304052057*^9}, {3.907030372815591*^9, 3.9070304865078115`*^9}, {
   3.907030557887286*^9, 3.9070305689133244`*^9}, {3.9070308911683903`*^9, 
   3.907030892187997*^9}, {3.9070604376835546`*^9, 3.907060445993576*^9}, {
   3.9070605369359646`*^9, 3.907060610391075*^9}, {3.9070607652596164`*^9, 
   3.907060779428796*^9}, {3.90706081432941*^9, 3.9070608151924467`*^9}, {
   3.9070608516888237`*^9, 3.907060854768076*^9}, {3.907060944967448*^9, 
   3.907060990845777*^9}, {3.907061076512681*^9, 3.9070611086597958`*^9}, {
   3.9070611484876804`*^9, 3.9070611988926153`*^9}, {3.9070612582075396`*^9, 
   3.907061352628416*^9}, {3.9070614831261873`*^9, 3.9070615845827394`*^9}, {
   3.907061784180231*^9, 3.9070618159858637`*^9}, {3.907061890477336*^9, 
   3.907061943454452*^9}, {3.9071484650166793`*^9, 3.90714866651295*^9}, {
   3.907148762155178*^9, 3.9071488404975348`*^9}, {3.9071488774252872`*^9, 
   3.9071489294181747`*^9}, {3.9071489765577335`*^9, 3.907148976814991*^9}, {
   3.9071491725272875`*^9, 3.907149241274995*^9}, 3.9071493285419173`*^9, {
   3.9071493746789184`*^9, 3.907149483905308*^9}, {3.9071495447705164`*^9, 
   3.907149550473424*^9}, {3.9071495819630795`*^9, 3.90714963340366*^9}, {
   3.9071497225947556`*^9, 3.9071497240775113`*^9}, {3.907149760297258*^9, 
   3.907149761731573*^9}, {3.9071498152856555`*^9, 3.907149875310998*^9}, 
   3.9071499205002947`*^9, {3.9071499577662582`*^9, 3.9071499702396035`*^9}, {
   3.9071500532046795`*^9, 3.9071500682462764`*^9}, {3.907218618548807*^9, 
   3.9072187011296597`*^9}, {3.9072195014873066`*^9, 
   3.9072195025316906`*^9}, {3.90721955313033*^9, 3.907219605997478*^9}, {
   3.9076388883376904`*^9, 3.907639028857774*^9}, {3.9076584642948866`*^9, 
   3.9076584677515554`*^9}, 3.9076585061822867`*^9, {3.9076585847633705`*^9, 
   3.9076586673533773`*^9}, {3.9076587071776705`*^9, 3.907658763185525*^9}, {
   3.907658814220379*^9, 3.9076588335250573`*^9}, {3.907658905205724*^9, 
   3.907658950762456*^9}, {3.907660119522422*^9, 3.9076601635769453`*^9}, 
   3.9126500418645983`*^9, {3.912650272877923*^9, 3.9126503212520823`*^9}, {
   3.912650484389138*^9, 3.912650572012165*^9}, {3.912650656766632*^9, 
   3.9126506581126027`*^9}, {3.9126507259529123`*^9, 3.912650777581822*^9}, 
   3.912651074711319*^9, {3.9126512031248045`*^9, 3.912651213319991*^9}, 
   3.912651703687234*^9, {3.912770083842639*^9, 3.9127701076862574`*^9}, {
   3.9128202786546226`*^9, 3.912820284120411*^9}, 3.9128203334420757`*^9, {
   3.9128203658705187`*^9, 3.91282056892971*^9}, {3.912820649630741*^9, 
   3.912820661602646*^9}, {3.9128206955003443`*^9, 3.912820724768431*^9}, 
   3.9128207658429365`*^9, {3.9128210569191675`*^9, 3.9128210648083296`*^9}, 
   3.9128210964617248`*^9, 3.9128211283606553`*^9, 3.9128212232449136`*^9, 
   3.912821276435539*^9, 3.9128214180597515`*^9, {3.912821544243472*^9, 
   3.9128215499947147`*^9}, {3.9128217996313906`*^9, 
   3.9128218286437273`*^9}, {3.912821877012741*^9, 3.912821923396287*^9}, {
   3.9128219675831423`*^9, 3.9128221124228954`*^9}, {3.912920245593502*^9, 
   3.912920245966591*^9}, {3.9139445874276905`*^9, 3.91394459507491*^9}, {
   3.9139450187138863`*^9, 3.9139450343858995`*^9}, {3.913945205447682*^9, 
   3.913945248472603*^9}, {3.913945412690005*^9, 3.9139455155179462`*^9}, {
   3.913958962378629*^9, 3.9139589785035114`*^9}, {3.9139590402712264`*^9, 
   3.9139590937141848`*^9}, 3.9139750141153145`*^9, {3.9139750744801207`*^9, 
   3.9139751224167085`*^9}, {3.9139752153934174`*^9, 3.91397523521216*^9}, {
   3.9139752681667395`*^9, 3.9139752765309496`*^9}, {3.9139754210256305`*^9, 
   3.91397543855688*^9}, {3.913975474761815*^9, 3.913975549799944*^9}, {
   3.9139756202766843`*^9, 3.913975621473342*^9}, {3.913976355232353*^9, 
   3.9139763564720173`*^9}, 3.913976468052901*^9, {3.913976504313478*^9, 
   3.9139766047022376`*^9}, {3.9139768730666857`*^9, 
   3.9139769991515765`*^9}, {3.9139805364785786`*^9, 
   3.9139805578142247`*^9}, {3.9143020649613595`*^9, 3.914302072021001*^9}, {
   3.914302194959444*^9, 3.914302202483561*^9}, {3.9191390449333115`*^9, 
   3.919139125489049*^9}, {3.9191391862084427`*^9, 3.919139212733096*^9}, {
   3.9191393296015463`*^9, 3.9191393355361643`*^9}, {3.919139393908128*^9, 
   3.9191394603885593`*^9}, 3.919139538292508*^9, {3.9191395898427453`*^9, 
   3.9191395945714526`*^9}, {3.9191397104148407`*^9, 3.9191397261812196`*^9}, 
   3.919139790543318*^9, 3.919139967192321*^9, {3.9191406455936623`*^9, 
   3.919140690845147*^9}, {3.9191407735213203`*^9, 3.9191407743776417`*^9}, {
   3.9191408181117997`*^9, 3.9191408270078845`*^9}, {3.9191408657281303`*^9, 
   3.919140902915256*^9}, {3.9191410060045266`*^9, 3.9191410203172483`*^9}, 
   3.919141070320388*^9, {3.919141163927287*^9, 3.9191411872159586`*^9}, {
   3.9191412577972193`*^9, 3.9191412976368313`*^9}, {3.9191688870873775`*^9, 
   3.919168933052214*^9}, {3.9201182584505105`*^9, 3.920118274636175*^9}, {
   3.9201183148461*^9, 3.920118343218148*^9}, {3.9201792697127*^9, 
   3.920179337060371*^9}, {3.920179374212452*^9, 3.920179400344658*^9}, {
   3.9201794569014792`*^9, 3.920179487538362*^9}, {3.92017952752343*^9, 
   3.920179632661135*^9}, {3.920179687305022*^9, 3.92017976326361*^9}, {
   3.9201798316074123`*^9, 3.9201798667633142`*^9}, {3.9201798998755927`*^9, 
   3.9201799158641057`*^9}, {3.920179953776236*^9, 3.9201799981623473`*^9}, {
   3.9201805316932325`*^9, 3.9201805494027853`*^9}, {3.9201860831182747`*^9, 
   3.9201861551547318`*^9}, 3.920186314100003*^9, 3.920186350665934*^9, {
   3.9201987605778465`*^9, 3.920198842313061*^9}, {3.9201988946130877`*^9, 
   3.9201989974218063`*^9}, {3.9201990338435297`*^9, 
   3.9201990430735903`*^9}, {3.920199690212242*^9, 3.9201996916760683`*^9}, {
   3.920200804471526*^9, 3.920200816376642*^9}, {3.9202009061806207`*^9, 
   3.920200923775221*^9}, {3.9202011376567793`*^9, 3.9202011413270454`*^9}, {
   3.9202012267021785`*^9, 3.920201296629879*^9}, {3.920201413993143*^9, 
   3.9202014557242785`*^9}, {3.920250158025154*^9, 3.9202501654817142`*^9}, 
   3.920250204189909*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], AbsoluteThickness[1], LineBox[CompressedData["
1:eJwlxQ04E3gAx3EmJkVvXrbUWUneKktJb0qOOy93ql11UtILilRemgoll4iU
FKtGCRm5XoRxwn5/bOuFTUwt3DlTRKR0nXdzd899n+fzfBfsP8bypaioqHj+
67//nybprH9P58QyyWO3hFXrxqkk64yR8PEvTLL/uu6RsGEqucfmVkjOMIlw
mXlL32cqmdYcckPjBJPEebGKmxVU8pu253jEQSbRKb97qKiGSqoEh8PZzkwy
L8ylwS+OSs4uXRWRrcUktn1XsyQ6VKIe6dbRbGRF1jOHo7ZO1SBd9nNdtugu
JUWMGm9zPXVyT5TOdVtlSXwzq7fVmkwhrSt14jUDzUnnqZQY44VqxKHemieL
NSVyZW1JvRWF9O/9yA6RmJDrra+Mrc1VSXfsbP3+MWNy1VmXt8dUhSQeahLa
2S8kypqg7YIjSlRtlpvnPGQQNs+rydJnHK+dNp8ZmfUNkSr0PDadHoW2Ws7d
c3RDcsvOVqM3Yxg/xnozdVxpZKrLhLkqdxD+ZtR9T3bpEY8Hl1ko+QqV1SnP
1lTOJo5Vws89+V/QLev8ul5zJuH9faAsL+8zWjRM8mTUaaRJ/Za20dWPcCnc
lqy8qUE4UeXXRNE96D9dGLjGkELm/xpkXFHSiZ9vqxwLCR5Hm82x2xe5ChSG
DoVY13yFvtrZ3zWMW1F1lWUUSu8DZaObYc+UVpz+vtih7EMvPobre9Z2tUBj
aIc/vaIXwi/35Un5LViQlTNq6t2LkI7mRpp1C3YsIS+ieB9QX7XiucWmZtid
6vU2XduDC2ff89295fD9MkspYndhbMI9iZMmg4VHfaSpgwLtMcdTP4XL8PKn
sS3zDRQQT+OmOXvKsGiLm5ltXzuu0DtzR2kySEyHdso57VhsE0H2cBphUTF9
N7f1T2wNzB1YnNyAmXHzuNud/oA7fzL3qHY9NO3bKE6sN6DXuBYz6qRwfK/v
Wqz+Bu9eppLGBCkuplRdO14mx6k+y+ZVmlIgfU18zwI57hp7aE1SJJipzCx5
OPgKo8kFgUnDL5A2jfZq6JEMuUf3LS94K0ZiATOh5JkUl987bSjliRF8UCGl
uksRttfCTeAvRmMhu2ZCJoEj6y+fuk8isEmSXauiDu025290jwkx22mWhK1e
C/pE3iRDtwaMOXdZqkeeQiXs0nQzeTVatHw/6kyI0d0fTLfiViNgRqlhwyUx
StrXrrBjVGOJm7TpxGMRWMI6v51LqrDupVlQkKoQegaKNON4AZa51dxbLiJ4
p5nPXz5DAMm5keeMfQSFoyH1G1Mr8aogy6p4DHBvm6K2O7MCwVnp5w+EChCb
YxaQUvYEy7Z18VzDyjG8Imi1+ocSrOccDEqQ8CE2WcOaE1SCm/3mHX4MPlIM
KIELBvmQN4R5GrCLsXzsWoYdhQ9PWnW55qIiBFSXaoTNLYKXoqlIdKMApZnK
e5LUh8jRefrWXpyLy3qiL0W8Byj7muqZ9pgHv/iL67il9zFu0JbhnJkDvWCa
xK85H/viIj68vZSNUHvrz5PzclH57k53+voMuBYPr+5ayoNgsL379e5bWGiG
6LoNOWhUexQ1My4NDTN+mHNzbzYsrjwc8Rm9jj2C2kAf5wzcMBqP5B9IhjbP
Q8kMuIV8a9q7EX4SKi51Jk1cTMMAu3gxrTIRc70mCzn111GhcO7cS4vDc8dE
xwMDqeC4ZNucOBqDk0vor63mpMA2YXOMsj0ar8esR57tuAJ2m//hc5vCofU0
Ss9yIBEn/SO1QjvYOMS5uVq4Mh5rLwS8Ofk8GGLfol1eJ89jKD1YbcPQYRjb
SM4MlkfDv0N06IjSB5Sp0m+NJiOQtNLPdjLYC5W5qglbY48juU43KC+ChYHE
gDtUwwAMOH+X6QUHvEzJ3vmGtQPyUZNGy6FFyAtvjew9po/Qhfp3ljFEgn8A
NloOAw==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwV0fk71AkAx/HBsLbDqrRbT5KErA7aSmmrL9GjwexGUkTTRR5bjo0MEdps
GSyDkU5HrnE9rsbS5vNlJ5JzEikZM65pyk0mE9O2P7yf1x/wXn/G19FDmUKh
0L/2v6KyzoTbt6XYM56RGrydSspTLFVu3ZJCy6DyDrGNSmpdKQpM5khhU8Es
VTWhkoesolzj2VI41qqsTTSmkiUdO/SjoqV42kUfKVhPJSNnkir9gqW4Xu90
YeA7Kqln5ii0cZFCm+sgOz2iQp6rat00u0oKu5vjZ+5nq5DRj6n8iLh3SEh+
EGO3VIW8NMz4mbb4HUyi5m2DIpTJHza9u5sWI0H188a8v2VKpNtvRXMblCRg
LLy4IT6nRHq+vGU2HD4MzayU55a9FHKZOfy6pocQUUdr7bKjkIGVK5KdvIeQ
y5qtcg77ggcn41I03w9C1zzsUg9TAS8l6xT5yUF4qpbHJ59egKx5XaBe7wD4
EtsmEWMeFmVG+7rdBxDayt+4xvMzjJN8lP/p6IcV61H6MVc5Xt97ndPr2A8l
o92FiWfn8GNm5KEtDWJsNGQOh5z4hJ9qnTsW7RfDVi3YuuyEDJRvHfYZ1oiw
52PDcnu/Wfja38zy3S4CUWT6NjDgI2z8GztHz/ahd4now6PYGUxazLsdtxNC
rrW7gOBMQ8M6mifc1YvomgM7F+dMgZd6qlVk9hZLDGgltOeTSB8sFe3X7UFV
NY3f2DcBrWv00lXab9BUOJN9UX0CckcrJ421r+Fld3mRt/8YNqwpn2Sod4N+
5akNkzeCzh0X6VvUXsGnzV4ervsBjQczHjqPdcKvXplS7CeFKcuk+W7PS9gq
gkb1BRLo6aqXu/V0INzMvWXr0WE4F7kmBz99AU9jrdSE2kFoxcq2L68T4PhE
KVdweADWD8ay6/9tRxJzkf30mBgXf4V+MaMN+bqR4ASJvn4wC6l3a4GVWHZA
zUqIQW46P2VrEyhbBVk7fHtweTIt5qRBI54FcKbU3nZjJO2IzN2wAS5XRz0s
PLog2fv52Mp5PoLH5to/NnZgNnTXTv5sHZpPBXMY3gKwCs5/s6meRIPI0zyn
tQWq11LnE4knyE9YUhv0+Rl0plkDNXurQKeNvzKN58PS0qPCdaAC6hlHtZuz
gNhOr6tDHSXQLKsUhHTzYOGbvwGlXKzrPLL5k2chQkcddZI0MiD2LBic+pKI
ZRN3v2cp2OhlBhaF0BKI4ksPp+J5bMRoEdeNhhIIO1l+K8eHDQ69UKM8gk1E
Kar+zBAmIPWGhcvxykRicnXJqH9YPI5qBBRU6nEI8ohRcdsCC+e7743tnLhN
uDesMolRRKI7nPIyMz+DSGndKEnxiQSv0PuJ4UwG0d5plpYpjEAdNffghX2Z
xM1nXJ2AsHBkuVr9sq0tkzimrNcnWAiBZhPnMX38ITETuPxUnMIf2v36aed1
cgiv66btWUI/vGeVD9mfySF4BvcjmGG+EBoYx+Rn5xBRjJWWXQveGBQs5hUY
5xJ6Hap1bMVpNFVzLGI25xErRH9YR4YxsNchViL3ziP6V89T+xZcMcCMKvHP
yyPC40ai7igcoGh5s1S+jkvc+6sxdmLBFqmf9HsrXLiEuXL10kKFJcR9Kwuq
2Fyi6IPT2jbFNohDD/8e3cAlMt9XBbTccKjpS8/NqZvjEv8BBmuy/A==
      "]]}}, {{}, {}, 
    {RGBColor[0, 0, 1], AbsoluteThickness[2], LineBox[CompressedData["
1:eJwVlHk81Nv/x8feHkVIEUXKV1pEbjiWqXRFEYoM6go3ZQ+VJWXPvoydsS8z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      "]]}}, {{{{InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "e"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.5",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.2699366901824727, -2.0959691922614136`}, {Left, Baseline},
        Alignment->{Left, Top}], InsetBox[
        StyleBox[
         TagBox[
          RowBox[{
           StyleBox[
            SubscriptBox["\[Tau]", "d"],
            FontSize->12], 
           StyleBox["=",
            FontSize->12], 
           StyleBox[" ",
            FontSize->12], 
           RowBox[{
            StyleBox["0.1",
             FontSize->12], 
            StyleBox["  ",
             FontSize->12], 
            StyleBox["ms",
             FontSize->12], " "}]}],
          "RawBoxes"],
         FontFamily->"Arial",
         FontSize->10,
         Background->GrayLevel[
          1.]], {-0.2756963273706807, -2.484858081150302}, {Left, Baseline},
        Alignment->{Left, Top}]}, InsetBox[
       RowBox[{"\[Theta]", "=", 
        RowBox[{"+", "1"}]}], {-0.19339534101618638`, -1.701004728266159}, {
       Left, Baseline},
       Alignment->{Left, Top}]}, InsetBox[
      StyleBox[
       TagBox[
        RowBox[{
         SubscriptBox[
          StyleBox["v",
           FontFamily->"Arial",
           FontSize->12,
           FontWeight->"Plain",
           FontSlant->"Plain",
           FontVariations->{"StrikeThrough"->False,
           "Underline"->False}], 
          RowBox[{"r", " "}]], 
         StyleBox["=",
          FontSize->12], 
         StyleBox[" ",
          FontSize->12], 
         RowBox[{
          StyleBox["0.4",
           FontSize->12], 
          StyleBox[" ",
           FontSize->12], 
          RowBox[{
           StyleBox["mV",
            FontSize->12], 
           StyleBox["/",
            FontSize->12], 
           StyleBox["s",
            FontSize->12], " "}]}]}],
        "RawBoxes"],
       FontFamily->"Arial",
       FontSize->10,
       Background->GrayLevel[
        1.]], {-0.31278249517113443`, -2.8176245210595985`}, {Left, Baseline},
      Alignment->{Left, Top}]}, {
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.2957303044547942, -0.8817088321578139}, \
{-0.48565570688903015`, -1.5348488474886404`}}]}, 
     {RGBColor[1., 0.32153022506559453`, 0.], AbsoluteThickness[2], 
      Arrowheads[{{0.042072662838444415`, 1, {
          GraphicsBox[{
            EdgeForm[None], 
            Dashing[{}], 
            PolygonBox[{{-1, 0.5}, {0, 0}, {-1, -0.5}}]}], 0.98}}}], 
      StrokeForm[RGBColor[0, 0.501961, 0.501961]], EdgeForm[{RGBColor[
      0., 0.5019607843137255, 0.5019607843137255], Opacity[1.], 
      AbsoluteThickness[2]}], EdgeForm[None], 
      ArrowBox[{{-0.5948937861018696, -0.9573199953510025}, \
{-0.4181332915624756, -0.38284528988184885`}}]}}}},
  AspectRatio->0.7,
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontSize -> 16},
  Frame->True,
  FrameLabel->{
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(u\\), \\(g\\)]\\) (V)\"", FontSize -> 20, 
      StripOnInput -> False], TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(I\\), \\(d\\)]\\) (\[Mu]A)\"", FontSize -> 
      20, StripOnInput -> False], TraditionalForm], 
    FormBox["\"\"", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  FrameTicks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {-0.5, 
      FormBox[
       RowBox[{"-", "0.5`"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {0.5, 
      FormBox["0.5`", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, None, None},
  ImagePadding->{{52., 25.}, {55., 24.}},
  ImageSize->360.,
  LabelStyle->(FontFamily -> "Arial"),
  Method->{},
  PlotRange->{{-1., 0.}, {-3., 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->Automatic]], "Input",
 CellChangeTimes->{{3.9202502279923677`*^9, 3.9202502333727875`*^9}}]
},
WindowSize->{1148, 681},
WindowMargins->{{366, Automatic}, {-6, Automatic}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.98}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->FrontEnd`FileName[{"Article"}, "JournalArticle.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 86, 1, 23, "Text"],
Cell[646, 23, 84, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[755, 28, 43077, 645, 328, "Input"],
Cell[43835, 675, 7405, 131, 288, "Output"],
Cell[51243, 808, 3892, 52, 30, "Output"]
}, Open  ]],
Cell[55150, 863, 84, 1, 23, "Text"],
Cell[CellGroupData[{
Cell[55259, 868, 64786, 1194, 1184, "Input"],
Cell[120048, 2064, 23888, 416, 296, "Output"]
}, Open  ]],
Cell[143951, 2483, 18708, 376, 296, "Input"],
Cell[162662, 2861, 29031, 567, 296, "Input"],
Cell[191696, 3430, 55042, 919, 708, "Input"],
Cell[246741, 4351, 17783, 361, 296, "Input"],
Cell[264527, 4714, 16342, 337, 296, "Input"],
Cell[280872, 5053, 55020, 918, 708, "Input"],
Cell[335895, 5973, 17247, 353, 288, "Input"],
Cell[353145, 6328, 55181, 920, 708, "Input"],
Cell[408329, 7250, 13791, 295, 292, InheritFromParent]
}
]
*)

(* End of internal cache information *)
